/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons;

import io.github.drmanganese.topaddons.TOPAddons;
import io.github.drmanganese.topaddons.api.ITOPAddon;
import io.github.drmanganese.topaddons.api.TOPAddon;
import io.github.drmanganese.topaddons.reference.EnumChip;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemArmor;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class AddonManager {
    public static final List<ITOPAddon> ADDONS = new LinkedList<ITOPAddon>();
    public static final Map<Class<? extends ItemArmor>, EnumChip> SPECIAL_HELMETS = new HashMap<Class<? extends ItemArmor>, EnumChip>();

    static void preInit(FMLPreInitializationEvent event) {
        Set asmDataSet = event.getAsmData().getAll(TOPAddon.class.getName());
        TOPAddons.LOGGER.info("Found {} addon candidates.", new Object[]{asmDataSet.size()});
        for (ASMDataTable.ASMData asmData : asmDataSet) {
            Map annotationInfo = asmData.getAnnotationInfo();
            String fancyName = (String)annotationInfo.get("fancyName");
            String dependency = (String)annotationInfo.get("dependency");
            int numHelmets = 0;
            boolean success = true;
            if (dependency == null || dependency.isEmpty()) {
                throw new IllegalArgumentException("No dependency specified for addon. Offender: " + asmData.getClassName());
            }
            if (Loader.isModLoaded((String)dependency)) {
                if (fancyName == null || fancyName.isEmpty()) {
                    for (ModContainer modContainer : Loader.instance().getModList()) {
                        if (!modContainer.getModId().equals(dependency)) continue;
                        fancyName = modContainer.getName();
                    }
                }
                if (dependency.equals("IC2") && Loader.isModLoaded((String)"IC2-Classic-Spmod")) {
                    TOPAddons.LOGGER.info("IC2 Classic found, skipping addon IC2");
                    success = false;
                } else {
                    try {
                        Class<?> clazz = Class.forName(asmData.getClassName());
                        if (ITOPAddon.class.isAssignableFrom(clazz)) {
                            ITOPAddon instance = (ITOPAddon)clazz.newInstance();
                            numHelmets = AddonManager.addHelmets(instance);
                            ADDONS.add(instance);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        TOPAddons.LOGGER.fatal("Classloader error while trying to create addon {}.", new Object[]{fancyName});
                        e.printStackTrace();
                        success = false;
                    }
                    catch (InstantiationException e) {
                        TOPAddons.LOGGER.error("Addon {} couldn't be instantiated, does its class have a constructor?", new Object[]{fancyName});
                        e.printStackTrace();
                        success = false;
                    }
                    catch (IllegalAccessException e) {
                        TOPAddons.LOGGER.error("Couldn't access constructor for addon {}.", new Object[]{fancyName});
                        e.printStackTrace();
                        success = false;
                    }
                }
                if (success) {
                    if (numHelmets > 0) {
                        TOPAddons.LOGGER.info("Created addon {} with {} special helmets.", new Object[]{fancyName, numHelmets});
                        continue;
                    }
                    TOPAddons.LOGGER.info("Created addon {}.", new Object[]{fancyName});
                    continue;
                }
                TOPAddons.LOGGER.fatal("Failed to create addon {}", new Object[]{fancyName});
                continue;
            }
            TOPAddons.LOGGER.info("Dependency ({}) for addon not found, skipping...", new Object[]{dependency});
        }
        ADDONS.sort((o1, o2) -> o1.getClass().getName().compareToIgnoreCase(o2.getClass().getName()));
        ADDONS.sort((o1, o2) -> {
            int order1 = o1.getClass().getAnnotation(TOPAddon.class).order();
            int order2 = o2.getClass().getAnnotation(TOPAddon.class).order();
            return Integer.compare(order1, order2);
        });
    }

    private static int addHelmets(ITOPAddon addon) {
        SPECIAL_HELMETS.putAll(addon.getSpecialHelmets());
        return addon.getSpecialHelmets().size();
    }
}

