/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import net.blay09.mods.cookingforblockheads.CookingConfig;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileSink
extends TileEntity {
    private final FluidTank waterTank = new WaterTank(16000);
    private final SinkItemProvider itemProvider = new SinkItemProvider(this.waterTank);

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.waterTank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.waterTank.readFromNBT(tagCompound);
    }

    public int getWaterAmount() {
        return this.waterTank.getFluidAmount();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityKitchenItemProvider.CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityKitchenItemProvider.CAPABILITY) {
            return (T)this.itemProvider;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.waterTank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private static class SinkItemProvider
    implements IKitchenItemProvider {
        private final List<ItemStack> itemStacks = Lists.newArrayList();
        private final FluidTank fluidTank;
        private int waterUsed;

        public SinkItemProvider(FluidTank fluidTank) {
            this.fluidTank = fluidTank;
            this.itemStacks.add(new ItemStack(Items.field_151131_as));
            this.itemStacks.addAll(CookingRegistry.getWaterItems());
        }

        @Override
        public void resetSimulation() {
            this.waterUsed = 0;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            if (!CookingConfig.sinkRequiresWater || this.fluidTank.getFluidAmount() - this.waterUsed > amount * 1000) {
                if (requireBucket && this.getStackInSlot(slot).func_77973_b() == Items.field_151117_aB && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return null;
                }
                if (simulate) {
                    this.waterUsed += amount * 1000;
                } else {
                    this.fluidTank.drain(amount * 1000, true);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)this.getStackInSlot(slot), (int)amount);
            }
            return null;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)itemStack, (ItemStack)providedStack)) continue;
                this.fluidTank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                break;
            }
            return null;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.itemStacks.get(slot);
        }
    }

    private static class WaterTank
    extends FluidTank {
        public WaterTank(int capacity) {
            super(capacity);
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (!CookingConfig.sinkRequiresWater || resource.getFluid() != FluidRegistry.WATER) {
                return resource.amount;
            }
            return super.fill(resource, doFill);
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (!CookingConfig.sinkRequiresWater && resource.getFluid() == FluidRegistry.WATER) {
                return resource.copy();
            }
            return super.drain(resource, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!CookingConfig.sinkRequiresWater) {
                return new FluidStack(FluidRegistry.WATER, maxDrain);
            }
            return super.drain(maxDrain, doDrain);
        }
    }
}

