/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container.inventory;

import java.util.List;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.balyware.ItemUtils;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryCraftBook
extends InventoryCrafting {
    public InventoryCraftBook(Container container) {
        super(container, 3, 3);
    }

    public ItemStack tryCraft(ItemStack outputItem, List<ItemStack> craftMatrix, EntityPlayer player, KitchenMultiBlock multiBlock) {
        int i;
        boolean requireContainer = CookingRegistry.doesItemRequireBucketForCrafting(outputItem);
        List<IKitchenItemProvider> inventories = CookingRegistry.getItemProviders(multiBlock, player.field_71071_by);
        for (IKitchenItemProvider itemProvider : inventories) {
            itemProvider.resetSimulation();
        }
        SourceItem[] sourceItems = new SourceItem[9];
        block1: for (i = 0; i < craftMatrix.size(); ++i) {
            ItemStack ingredient = craftMatrix.get(i);
            if (ingredient == null) continue;
            for (int j = 0; j < inventories.size(); ++j) {
                IKitchenItemProvider itemProvider = inventories.get(j);
                for (int k = 0; k < itemProvider.getSlots(); ++k) {
                    ItemStack itemStack = itemProvider.getStackInSlot(k);
                    if (!ItemUtils.areItemStacksEqualWithWildcard(itemStack, ingredient) || (itemStack = itemProvider.useItemStack(k, 1, true, inventories, requireContainer)) == null) continue;
                    sourceItems[i] = new SourceItem(inventories.get(j), k, itemStack);
                    continue block1;
                }
            }
        }
        for (i = 0; i < sourceItems.length; ++i) {
            this.func_70299_a(i, sourceItems[i] != null ? sourceItems[i].getSourceStack() : null);
        }
        IRecipe craftRecipe = CookingRegistry.findFoodRecipe(this, player.field_70170_p);
        if (craftRecipe == null || craftRecipe.func_77571_b() == null || craftRecipe.func_77571_b().func_77973_b() != outputItem.func_77973_b()) {
            return null;
        }
        ItemStack result = craftRecipe.func_77572_b((InventoryCrafting)this);
        if (result != null) {
            this.fireEventsAndHandleAchievements(player, result);
            for (int i2 = 0; i2 < this.func_70302_i_(); ++i2) {
                ItemStack containerItem;
                ItemStack itemStack = this.func_70301_a(i2);
                if (itemStack == null || sourceItems[i2] == null) continue;
                IKitchenItemProvider sourceProvider = sourceItems[i2].getSourceProvider();
                if (sourceItems[i2].getSourceSlot() != -1) {
                    sourceProvider.resetSimulation();
                    sourceProvider.useItemStack(sourceItems[i2].getSourceSlot(), 1, false, inventories, requireContainer);
                }
                if ((containerItem = ForgeHooks.getContainerItem((ItemStack)itemStack)) == null) continue;
                System.out.println("Got a container item, returning it to source provider");
                ItemStack restStack = sourceProvider.returnItemStack(containerItem);
                if (restStack == null || restStack.field_77994_a <= 0) continue;
                System.out.println("apparently the source provider didn't want it back so I'll just drop it in your inventory");
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)restStack);
            }
        }
        return result;
    }

    private void fireEventsAndHandleAchievements(EntityPlayer player, ItemStack result) {
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, result, (IInventory)this);
        result.func_77980_a(player.field_70170_p, player, 1);
        if (result.func_77973_b() == Items.field_151025_P) {
            player.func_71064_a((StatBase)AchievementList.field_187988_m, 1);
        } else if (result.func_77973_b() == Items.field_151105_aU) {
            player.func_71064_a((StatBase)AchievementList.field_76011_n, 1);
        }
    }

    private static class SourceItem {
        private IKitchenItemProvider sourceProvider;
        private int sourceSlot;
        private ItemStack sourceStack;

        public SourceItem(IKitchenItemProvider sourceProvider, int sourceSlot, ItemStack sourceStack) {
            this.sourceProvider = sourceProvider;
            this.sourceSlot = sourceSlot;
            this.sourceStack = sourceStack;
        }

        public IKitchenItemProvider getSourceProvider() {
            return this.sourceProvider;
        }

        public int getSourceSlot() {
            return this.sourceSlot;
        }

        public ItemStack getSourceStack() {
            return this.sourceStack;
        }
    }
}

