/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.block.BlockKitchen;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.TileSink;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockSink
extends BlockKitchen {
    public BlockSink() {
        super(Material.field_151575_d);
        this.setRegistryName("cookingforblockheads", "sink");
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack resultStack = CookingRegistry.getSinkOutput(heldItem);
        if (resultStack != null) {
            NBTTagCompound tagCompound = heldItem.func_77978_p();
            ItemStack newItem = resultStack.func_77946_l();
            if (tagCompound != null) {
                newItem.func_77982_d(tagCompound);
            }
            if (heldItem.field_77994_a <= 1) {
                player.func_184611_a(hand, newItem);
            } else if (player.field_71071_by.func_70441_a(newItem)) {
                --heldItem.field_77994_a;
            }
            this.spawnParticles(world, pos, state);
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
            FluidUtil.interactWithFluidHandler((ItemStack)heldItem, (IFluidHandler)fluidHandler, (EntityPlayer)player);
            return heldItem != null && !(heldItem.func_77973_b() instanceof ItemBlock);
        }
        return true;
    }

    private void spawnParticles(World world, BlockPos pos, IBlockState state) {
        float dripWaterX = 0.0f;
        float dripWaterZ = 0.0f;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                dripWaterZ = 0.25f;
                dripWaterX = -0.05f;
                break;
            }
            case SOUTH: {
                dripWaterX = 0.25f;
                break;
            }
            case WEST: {
                dripWaterX = 0.25f;
                dripWaterZ = 0.25f;
                break;
            }
            case EAST: {
                dripWaterZ = -0.05f;
            }
        }
        float particleX = (float)pos.func_177958_n() + 0.5f;
        float particleY = (float)pos.func_177956_o() + 1.25f;
        float particleZ = (float)pos.func_177952_p() + 0.5f;
        world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)particleX + (double)dripWaterX, (double)particleY - (double)0.45f, (double)particleZ + (double)dripWaterZ, 0.0, 0.0, 0.0, new int[0]);
        for (int i = 0; i < 5; ++i) {
            world.func_175688_a(EnumParticleTypes.WATER_SPLASH, (double)particleX + Math.random() - 0.5, (double)particleY + Math.random() - 0.5, (double)particleZ + Math.random() - 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileSink();
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        for (String s : I18n.func_135052_a((String)("tooltip." + this.getRegistryName() + ".description"), (Object[])new Object[0]).split("\\\\n")) {
            tooltip.add(TextFormatting.GRAY + s);
        }
    }
}

