/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.plant;

import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import jeresources.util.CollectionHelper;
import jeresources.util.RenderHelper;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PlantWrapper
extends BlankRecipeWrapper
implements ITooltipCallback<ItemStack> {
    private PlantEntry plantEntry;
    private IBlockState state;
    private long timer = -1L;
    private static final int TICKS = 1000;

    public PlantWrapper(PlantEntry entry) {
        this.plantEntry = entry;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.plantEntry.getPlantItemStack());
        ingredients.setOutputs(ItemStack.class, this.plantEntry.getLootDropStacks());
    }

    @Nonnull
    public List getInputs() {
        return CollectionHelper.create(this.plantEntry.getPlantItemStack());
    }

    @Deprecated
    public List<ItemStack> getDrops() {
        return this.plantEntry.getLootDropStacks();
    }

    @Nonnull
    public List getOutputs() {
        return this.plantEntry.getLootDropStacks();
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        RenderHelper.renderBlock(this.getFarmland(), 26.0f, 50.0f, -10.0f, 20.0f, 0.4f);
        RenderHelper.renderBlock(this.getBlockState(), 26.0f, 32.0f, 10.0f, 20.0f, 0.4f);
    }

    public void onTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (!input) {
            tooltip.add(this.getChanceString(ingredient));
        }
    }

    public float getChance(ItemStack itemStack) {
        PlantDrop drop = this.plantEntry.getDrop(itemStack);
        switch (drop.getDropKind()) {
            case chance: {
                return drop.getChance();
            }
            case weight: {
                return (float)drop.getWeight() / (float)this.plantEntry.getTotalWeight();
            }
            case minMax: {
                return Float.NaN;
            }
        }
        return 0.0f;
    }

    public int[] getMinMax(ItemStack itemStack) {
        PlantDrop drop = this.plantEntry.getDrop(itemStack);
        return new int[]{drop.getMinDrop(), drop.getMaxDrop()};
    }

    private String getChanceString(ItemStack itemStack) {
        String toPrint;
        float chance = this.getChance(itemStack);
        if (Float.isNaN(chance)) {
            int[] minMax = this.getMinMax(itemStack);
            toPrint = minMax[0] + (minMax[0] == minMax[1] ? "" : " - " + minMax[1]);
        } else {
            toPrint = String.format("%2.2f", Float.valueOf(chance * 100.0f)).replace(",", ".") + "%";
        }
        return toPrint;
    }

    private IBlockState getBlockState() {
        if (this.plantEntry.getPlant() != null) {
            if (this.timer == -1L) {
                this.timer = System.currentTimeMillis() + 1000L;
            }
            if (this.state == null) {
                this.state = this.plantEntry.getPlant().getPlant(null, null);
            }
            if (System.currentTimeMillis() > this.timer) {
                this.state = this.state.func_177231_a((IProperty)BlockCrops.field_176488_a);
                this.timer = System.currentTimeMillis() + 1000L;
            }
            return this.state;
        }
        return Block.func_149634_a((Item)this.plantEntry.getPlantItemStack().func_77973_b()).func_176203_a(this.plantEntry.getPlantItemStack().func_77952_i());
    }

    private IBlockState getFarmland() {
        return Blocks.field_150458_ak.func_176223_P();
    }
}

