/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.minecraft;

import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.distributions.DistributionTriangular;
import jeresources.api.distributions.DistributionUnderWater;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.api.restrictions.BiomeRestriction;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.CompatBase;
import jeresources.compatibility.minecraft.RenderHooks;
import jeresources.entry.DungeonEntry;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import jeresources.entry.WorldGenEntry;
import jeresources.util.LootTableHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableManager;

public class MinecraftCompat
extends CompatBase {
    @Override
    public void init(boolean worldGen) {
        this.registerVanillaMobs();
        this.registerDungeonLoot();
        if (worldGen) {
            this.registerOres();
        }
        this.registerVanillaPlants();
    }

    private void registerVanillaMobs() {
        World world = MinecraftCompat.getWorld();
        LootTableManager manager = LootTableHelper.getManager(world);
        LootTableHelper.getAllMobLootTables(world).entrySet().stream().map(entry -> new MobEntry((EntityLivingBase)entry.getValue(), manager.func_186521_a((ResourceLocation)entry.getKey()))).forEach(this::registerMob);
        this.registerMobRenderHook(EntityBat.class, RenderHooks.BAT);
        this.registerMobRenderHook(EntityDragon.class, RenderHooks.ENDER_DRAGON);
        this.registerMobRenderHook(EntityGuardian.class, RenderHooks.ELDER_GUARDIAN);
        this.registerMobRenderHook(EntitySquid.class, RenderHooks.SQUID);
        this.registerMobRenderHook(EntityGiantZombie.class, RenderHooks.GIANT);
    }

    private void registerDungeonLoot() {
        World world = MinecraftCompat.getWorld();
        LootTableManager manager = LootTableHelper.getManager(world);
        LootTableHelper.getAllChestLootTablesResourceLocations().stream().map(resourceLocation -> new DungeonEntry(resourceLocation.func_110623_a(), manager.func_186521_a(resourceLocation))).forEach(this::registerDungeonEntry);
    }

    private void registerOres() {
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150369_x), (DistributionBase)new DistributionTriangular(15, 15, 0.001f), true, new LootDrop(new ItemStack(Items.field_151100_aR, 4, 4))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150366_p), (DistributionBase)new DistributionSquare(20, 8, 1, 64), new LootDrop[0]));
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150450_ax), (DistributionBase)new DistributionSquare(8, 7, 1, 16), true, new LootDrop(new ItemStack(Items.field_151137_ax, 4))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150482_ag), (DistributionBase)new DistributionSquare(1, 7, 1, 16), true, new LootDrop(new ItemStack(Items.field_151045_i))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150412_bA), (DistributionBase)new DistributionSquare(6, 1, 4, 32), new Restriction(BiomeRestriction.EXTREME_HILLS), true, new LootDrop(new ItemStack(Items.field_151166_bC))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150352_o), (DistributionBase)new DistributionSquare(2, 8, 1, 32), new LootDrop[0]));
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150365_q), (DistributionBase)new DistributionSquare(20, 16, 1, 128), true, new LootDrop(new ItemStack(Items.field_151044_h))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150449_bY), (DistributionBase)new DistributionSquare(20, 14, 1, 126), new Restriction(DimensionRestriction.NETHER), true, new LootDrop(new ItemStack(Items.field_151128_bU, 4))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack(Blocks.field_150435_aG), (DistributionBase)new DistributionUnderWater(0.0035f), new LootDrop(new ItemStack(Items.field_151119_aD, 4))));
    }

    private void registerVanillaPlants() {
        ItemSeedFood potatoPlant = (ItemSeedFood)Items.field_151174_bG;
        PlantDrop potato = new PlantDrop(new ItemStack(Items.field_151174_bG), 1, 4);
        PlantDrop poisonous = new PlantDrop(new ItemStack(Items.field_151170_bI), 0.02f);
        this.registerPlant(new PlantEntry(potatoPlant, potato, poisonous));
        ItemSeedFood carrotPlant = (ItemSeedFood)Items.field_151172_bF;
        PlantDrop carrot = new PlantDrop(new ItemStack(Items.field_151172_bF), 1, 4);
        this.registerPlant(new PlantEntry(carrotPlant, carrot));
        ItemSeeds wheatPlant = (ItemSeeds)Items.field_151014_N;
        PlantDrop wheat = new PlantDrop(new ItemStack(Items.field_151015_O), 1, 1);
        PlantDrop seeds = new PlantDrop(new ItemStack(Items.field_151014_N), 0, 3);
        this.registerPlant(new PlantEntry(wheatPlant, wheat, seeds));
        ItemSeeds melonStem = (ItemSeeds)Items.field_151081_bc;
        PlantDrop melonSlice = new PlantDrop(new ItemStack(Items.field_151127_ba), 3, 7);
        this.registerPlant(new PlantEntry(melonStem, melonSlice));
        ItemSeeds pumpkinStem = (ItemSeeds)Items.field_151080_bb;
        PlantDrop pumpkin = new PlantDrop(new ItemStack(Blocks.field_150423_aK), 1, 1);
        this.registerPlant(new PlantEntry(pumpkinStem, pumpkin));
    }
}

