/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.running;

import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.config.GeneralConfiguration;
import mcjty.rftoolscontrol.logic.running.ProgException;
import mcjty.rftoolscontrol.logic.running.RunningProgram;
import net.minecraft.nbt.NBTTagCompound;

public class CpuCore {
    private RunningProgram program = null;
    private int tier;
    private boolean debug = false;

    public void setTier(int tier) {
        this.tier = tier;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void run(ProcessorTileEntity processor) {
        if (this.debug) {
            return;
        }
        for (int i = 0; i < GeneralConfiguration.coreSpeed[this.tier]; ++i) {
            boolean rc = false;
            try {
                rc = this.program.run(processor);
            }
            catch (ProgException e) {
                processor.exception(e.getExceptionType(), this.program);
                this.program.killMe();
            }
            if (this.program.isDead()) {
                this.stopProgram(processor);
                return;
            }
            if (rc) continue;
            return;
        }
    }

    public void step(ProcessorTileEntity processor) {
        try {
            this.program.run(processor);
        }
        catch (ProgException e) {
            processor.exception(e.getExceptionType(), this.program);
            this.program.killMe();
        }
        if (this.program.isDead()) {
            this.stopProgram(processor);
        }
    }

    public int getTier() {
        return this.tier;
    }

    public boolean hasProgram() {
        return this.program != null;
    }

    public RunningProgram getProgram() {
        return this.program;
    }

    public void stopProgram() {
        this.program = null;
    }

    private void stopProgram(ProcessorTileEntity processor) {
        if (RunningProgram.DEBUG) {
            System.out.println("Core: stopping program");
        }
        processor.clearRunningEvent(this.program.getCardIndex(), this.program.getEventIndex());
        this.program = null;
    }

    public void startProgram(RunningProgram program) {
        if (RunningProgram.DEBUG) {
            System.out.println("Core: starting program = " + program);
        }
        this.program = program;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.program != null) {
            this.program.writeToNBT(tag);
        }
        tag.func_74768_a("tier", this.tier);
        tag.func_74757_a("debug", this.debug);
        return tag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.program = RunningProgram.readFromNBT(tag);
        this.tier = tag.func_74762_e("tier");
        this.debug = tag.func_74767_n("debug");
    }
}

