/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.multitank;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.rftoolscontrol.blocks.multitank.MultiTankFluidProperties;
import mcjty.rftoolscontrol.blocks.multitank.MultiTankHandler;
import mcjty.typed.Type;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class MultiTankTileEntity
extends GenericTileEntity {
    public static final String CMD_GETFLUIDS = "getFluids";
    public static final String CLIENTCMD_GETFLUIDS = "getFluids";
    public static final int TANKS = 4;
    public static final int MAXCAPACITY = 10000;
    private final MultiTankFluidProperties[] properties = new MultiTankFluidProperties[4];
    private final FluidStack[] fluids = new FluidStack[4];
    private MultiTankHandler handler = null;

    public MultiTankTileEntity() {
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, null, 10000);
        }
    }

    public MultiTankFluidProperties[] getProperties() {
        return this.properties;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("f" + i)), 10000);
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        for (int i = 0; i < 4; ++i) {
            FluidStack contents = this.properties[i].getContents();
            if (contents == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            contents.writeToNBT(tag);
            tagCompound.func_74782_a("f" + i, (NBTBase)tag);
        }
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, Map<String, Argument> args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getFluids".equals(command)) {
            ArrayList<FluidStack> result = new ArrayList<FluidStack>(4);
            for (MultiTankFluidProperties property : this.properties) {
                result.add(property.getContents());
            }
            return type.convert(result);
        }
        return Collections.emptyList();
    }

    public <T> boolean execute(String command, List<T> list, Type<T> type) {
        boolean rc = super.execute(command, list, type);
        if (rc) {
            return true;
        }
        if ("getFluids".equals(command)) {
            for (int i = 0; i < 4; ++i) {
                this.properties[i].set((FluidStack)list.get(i));
            }
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.handler == null) {
                this.handler = new MultiTankHandler(this);
            }
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.handler);
        }
        return (T)super.getCapability(capability, facing);
    }
}

