/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.api.parameters;

import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;

public class Parameter {
    private final ParameterType parameterType;
    private final ParameterValue parameterValue;

    private Parameter(Builder builder) {
        this.parameterType = builder.parameterType;
        this.parameterValue = builder.parameterValue;
    }

    public boolean isSet() {
        return this.parameterValue != null && this.parameterValue.getValue() != null;
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public ParameterValue getParameterValue() {
        return this.parameterValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ParameterType parameterType;
        private ParameterValue parameterValue;

        public Builder type(ParameterType parameterType) {
            this.parameterType = parameterType;
            return this;
        }

        public Builder value(ParameterValue value) {
            this.parameterValue = value;
            return this;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }
}

