/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.hopperducts;

import java.util.List;
import net.fybertech.hopperducts.BlockGratedHopper;
import net.fybertech.hopperducts.ContainerGratedHopper;
import net.fybertech.hopperducts.HopperDuctsMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityGratedHopper
extends TileEntityLockable
implements IHopper,
ITickable,
ISidedInventory {
    private ItemStack[] inventory = new ItemStack[10];
    private int realSlotCount = 5;
    private String customName;
    private int transferCooldown = -1;
    private int totalCounter = 0;
    private static final int[] slots_inventory = new int[]{0, 1, 2, 3, 4};
    private static final int[] slots_filter = new int[]{5, 6, 7, 8, 9};
    private IItemHandler itemHandler;

    public void func_145836_u() {
        super.func_145836_u();
    }

    public boolean func_145837_r() {
        return super.func_145837_r();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !(newSate.func_177230_c() instanceof BlockGratedHopper);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[10];
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.transferCooldown = compound.func_74762_e("TransferCooldown");
        for (int n = 0; n < nbttaglist.func_74745_c(); ++n) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(n);
            byte slotNum = nbttagcompound1.func_74771_c("Slot");
            if (slotNum < 0 || slotNum >= this.inventory.length) continue;
            this.inventory[slotNum] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList tagList = new NBTTagList();
        for (int n = 0; n < this.inventory.length; ++n) {
            if (this.inventory[n] == null) continue;
            NBTTagCompound newSlotTag = new NBTTagCompound();
            newSlotTag.func_74774_a("Slot", (byte)n);
            this.inventory[n].func_77955_b(newSlotTag);
            tagList.func_74742_a((NBTBase)newSlotTag);
        }
        compound.func_74782_a("Items", (NBTBase)tagList);
        compound.func_74768_a("TransferCooldown", this.transferCooldown);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70302_i_() {
        return this.realSlotCount;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory[index] != null) {
            if (this.inventory[index].field_77994_a <= count) {
                ItemStack itemstack = this.inventory[index];
                this.inventory[index] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[index].func_77979_a(count);
            if (this.inventory[index].field_77994_a == 0) {
                this.inventory[index] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.inventory[index] != null) {
            ItemStack itemstack = this.inventory[index];
            this.inventory[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.gratedhopper";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String customNameIn) {
        this.customName = customNameIn;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            if (this.transferCooldown <= 0) {
                this.transferCooldown = HopperDuctsMod.cooldownTime;
                if (!BlockGratedHopper.isEnabled(this.func_145832_p())) {
                    return;
                }
                boolean contentChanged = false;
                if (!this.isGratedHopperEmpty()) {
                    contentChanged = this.pushOutItems();
                }
                if (!this.isGratedHopperFull()) {
                    boolean bl = contentChanged = TileEntityGratedHopper.suckItemsIntoHopper(this) || contentChanged;
                }
                if (contentChanged) {
                    this.func_70296_d();
                }
            }
        }
    }

    private boolean isGratedHopperEmpty() {
        ItemStack[] stacks = this.inventory;
        int invSize = this.func_70302_i_();
        for (int n = 0; n < invSize; ++n) {
            if (stacks[n] == null) continue;
            return false;
        }
        return true;
    }

    private boolean isGratedHopperFull() {
        ItemStack[] stacks = this.inventory;
        int invSize = this.func_70302_i_();
        for (int n = 0; n < invSize; ++n) {
            ItemStack itemstack = stacks[n];
            if (itemstack != null && itemstack.field_77994_a == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private boolean pushOutItems() {
        IInventory iinventory = this.getOutputInventory();
        if (iinventory == null) {
            return false;
        }
        EnumFacing enumfacing = BlockGratedHopper.getFacing(this.func_145832_p()).func_176734_d();
        if (this.isInventoryFull(iinventory, enumfacing)) {
            return false;
        }
        int isize = this.func_70302_i_();
        for (int i = 0; i < isize; ++i) {
            ItemStack stackInSlot = this.func_70301_a(i);
            if (stackInSlot == null || !this.isValidFilterItem(stackInSlot)) continue;
            ItemStack itemstack = stackInSlot.func_77946_l();
            ItemStack itemstack1 = TileEntityGratedHopper.insertStack(iinventory, this.func_70298_a(i, 1), enumfacing);
            if (itemstack1 == null || itemstack1.field_77994_a == 0) {
                iinventory.func_70296_d();
                return true;
            }
            this.func_70299_a(i, itemstack);
        }
        return false;
    }

    private boolean isInventoryFull(IInventory paramInventory, EnumFacing paramFacing) {
        if (paramInventory instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)paramInventory;
            int[] slotNums = sidedInventory.func_180463_a(paramFacing);
            for (int n = 0; n < slotNums.length; ++n) {
                ItemStack itemstack = sidedInventory.func_70301_a(slotNums[n]);
                if (itemstack != null && itemstack.field_77994_a == itemstack.func_77976_d()) continue;
                return false;
            }
        } else {
            int invSize = paramInventory.func_70302_i_();
            for (int n = 0; n < invSize; ++n) {
                ItemStack itemstack1 = paramInventory.func_70301_a(n);
                if (itemstack1 != null && itemstack1.field_77994_a == itemstack1.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isInventoryEmpty(IInventory paramInventory, EnumFacing paramFacing) {
        if (paramInventory instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)paramInventory;
            int[] slotNums = sidedInventory.func_180463_a(paramFacing);
            for (int n = 0; n < slotNums.length; ++n) {
                if (sidedInventory.func_70301_a(slotNums[n]) == null) continue;
                return false;
            }
        } else {
            int invSize = paramInventory.func_70302_i_();
            for (int n = 0; n < invSize; ++n) {
                if (paramInventory.func_70301_a(n) == null) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean suckItemsIntoHopper(IHopper paramHopper) {
        IInventory iinventory = TileEntityGratedHopper.getInventoryAboveHopper(paramHopper);
        if (iinventory != null) {
            EnumFacing enumfacing = EnumFacing.DOWN;
            if (TileEntityGratedHopper.isInventoryEmpty(iinventory, enumfacing)) {
                return false;
            }
            if (iinventory instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)iinventory;
                int[] slotNums = sidedInventory.func_180463_a(enumfacing);
                for (int n = 0; n < slotNums.length; ++n) {
                    if (!TileEntityGratedHopper.addSingleItemFromInventorySlotToHopper(paramHopper, iinventory, slotNums[n], enumfacing)) continue;
                    return true;
                }
            } else {
                int invSize = iinventory.func_70302_i_();
                for (int n = 0; n < invSize; ++n) {
                    if (!TileEntityGratedHopper.addSingleItemFromInventorySlotToHopper(paramHopper, iinventory, n, enumfacing)) continue;
                    return true;
                }
            }
        } else {
            EntityItem entityitem = TileEntityGratedHopper.getItemEntityAtBlock(paramHopper.func_145831_w(), paramHopper.func_96107_aA(), paramHopper.func_96109_aB() + 1.0, paramHopper.func_96108_aC());
            if (entityitem != null) {
                return TileEntityGratedHopper.addItemEntityToInventory((IInventory)paramHopper, entityitem);
            }
        }
        return false;
    }

    private static boolean addSingleItemFromInventorySlotToHopper(IHopper paramHopper, IInventory paramInventory, int paramSlot, EnumFacing paramFacing) {
        ItemStack mainStack = paramInventory.func_70301_a(paramSlot);
        if (mainStack != null && TileEntityGratedHopper.canExtractItemFromInventory(paramInventory, mainStack, paramSlot, paramFacing)) {
            ItemStack mainStackCopy = mainStack.func_77946_l();
            ItemStack leftoverStack = TileEntityGratedHopper.insertStack((IInventory)paramHopper, paramInventory.func_70298_a(paramSlot, 1), null);
            if (leftoverStack == null || leftoverStack.field_77994_a == 0) {
                paramInventory.func_70296_d();
                return true;
            }
            paramInventory.func_70299_a(paramSlot, mainStackCopy);
        }
        return false;
    }

    private static boolean addItemEntityToInventory(IInventory paramInventory, EntityItem paramEntityItem) {
        if (paramInventory == null || paramEntityItem == null) {
            return false;
        }
        boolean flag = false;
        ItemStack itemstack = paramEntityItem.func_92059_d().func_77946_l();
        ItemStack itemstack1 = TileEntityGratedHopper.insertStack(paramInventory, itemstack, null);
        if (itemstack1 != null && itemstack1.field_77994_a != 0) {
            paramEntityItem.func_92058_a(itemstack1);
        } else {
            flag = true;
            paramEntityItem.func_70106_y();
        }
        return flag;
    }

    private static ItemStack insertStack(IInventory paramInventory, ItemStack paramStack, EnumFacing paramFacing) {
        if (paramInventory instanceof ISidedInventory && paramFacing != null) {
            ISidedInventory sidedInventory = (ISidedInventory)paramInventory;
            int[] slotNums = sidedInventory.func_180463_a(paramFacing);
            for (int n = 0; n < slotNums.length && paramStack != null && paramStack.field_77994_a > 0; ++n) {
                paramStack = TileEntityGratedHopper.func_174916_c(paramInventory, paramStack, slotNums[n], paramFacing);
            }
        } else {
            int invSize = paramInventory.func_70302_i_();
            for (int n = 0; n < invSize && paramStack != null && paramStack.field_77994_a > 0; ++n) {
                paramStack = TileEntityGratedHopper.func_174916_c(paramInventory, paramStack, n, paramFacing);
            }
        }
        if (paramStack != null && paramStack.field_77994_a == 0) {
            paramStack = null;
        }
        return paramStack;
    }

    private static boolean canInsertItemToInventory(IInventory p_174920_0_, ItemStack p_174920_1_, int p_174920_2_, EnumFacing p_174920_3_) {
        return !p_174920_0_.func_94041_b(p_174920_2_, p_174920_1_) ? false : !(p_174920_0_ instanceof ISidedInventory) || ((ISidedInventory)p_174920_0_).func_180462_a(p_174920_2_, p_174920_1_, p_174920_3_);
    }

    private static boolean canExtractItemFromInventory(IInventory p_174921_0_, ItemStack p_174921_1_, int p_174921_2_, EnumFacing p_174921_3_) {
        return !(p_174921_0_ instanceof ISidedInventory) || ((ISidedInventory)p_174921_0_).func_180461_b(p_174921_2_, p_174921_1_, p_174921_3_);
    }

    private static ItemStack func_174916_c(IInventory paramInventory, ItemStack paramStack, int paramSlot, EnumFacing paramFace) {
        ItemStack mainStack = paramInventory.func_70301_a(paramSlot);
        if (TileEntityGratedHopper.canInsertItemToInventory(paramInventory, paramStack, paramSlot, paramFace)) {
            int max;
            boolean success = false;
            if (mainStack == null) {
                max = Math.min(paramStack.func_77976_d(), paramInventory.func_70297_j_());
                if (max >= paramStack.field_77994_a) {
                    paramInventory.func_70299_a(paramSlot, paramStack);
                    paramStack = null;
                } else {
                    paramInventory.func_70299_a(paramSlot, paramStack.func_77979_a(max));
                }
                success = true;
            } else if (TileEntityGratedHopper.canCombine(mainStack, paramStack) && (max = Math.min(paramStack.func_77976_d(), paramInventory.func_70297_j_())) > mainStack.field_77994_a) {
                int size = Math.min(paramStack.field_77994_a, max - mainStack.field_77994_a);
                paramStack.field_77994_a -= size;
                mainStack.field_77994_a += size;
                boolean bl = success = size > 0;
            }
            if (success) {
                if (paramInventory instanceof TileEntityGratedHopper) {
                    TileEntityGratedHopper tileentityhopper = (TileEntityGratedHopper)paramInventory;
                    if (tileentityhopper.mayTransfer()) {
                        tileentityhopper.setTransferCooldown(8);
                    }
                    paramInventory.func_70296_d();
                }
                paramInventory.func_70296_d();
            }
        }
        return paramStack;
    }

    private IInventory getOutputInventory() {
        EnumFacing enumfacing = BlockGratedHopper.getFacing(this.func_145832_p());
        return TileEntityGratedHopper.getInventoryAtLocation(this.func_145831_w(), this.field_174879_c.func_177958_n() + enumfacing.func_82601_c(), this.field_174879_c.func_177956_o() + enumfacing.func_96559_d(), this.field_174879_c.func_177952_p() + enumfacing.func_82599_e());
    }

    private static IInventory getInventoryAboveHopper(IHopper p_145884_0_) {
        return TileEntityGratedHopper.getInventoryAtLocation(p_145884_0_.func_145831_w(), p_145884_0_.func_96107_aA(), p_145884_0_.func_96109_aB() + 1.0, p_145884_0_.func_96108_aC());
    }

    private static EntityItem getItemEntityAtBlock(World worldIn, double x, double y, double z) {
        List list = worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0), EntitySelectors.field_94557_a);
        return list.size() > 0 ? (EntityItem)list.get(0) : null;
    }

    private static IInventory getInventoryAtLocation(World worldIn, double p_145893_1_, double p_145893_3_, double p_145893_5_) {
        List list;
        Block block;
        IInventory object = null;
        int i = MathHelper.func_76128_c((double)p_145893_1_);
        int j = MathHelper.func_76128_c((double)p_145893_3_);
        int k = MathHelper.func_76128_c((double)p_145893_5_);
        BlockPos blockpos = new BlockPos(i, j, k);
        TileEntity tileentity = worldIn.func_175625_s(new BlockPos(i, j, k));
        if (tileentity instanceof IInventory && (object = (IInventory)tileentity) instanceof TileEntityChest && (block = worldIn.func_180495_p(new BlockPos(i, j, k)).func_177230_c()) instanceof BlockChest) {
            object = ((BlockChest)block).func_180676_d(worldIn, blockpos);
        }
        if (object == null && (list = worldIn.func_175674_a((Entity)null, new AxisAlignedBB(p_145893_1_, p_145893_3_, p_145893_5_, p_145893_1_ + 1.0, p_145893_3_ + 1.0, p_145893_5_ + 1.0), EntitySelectors.field_96566_b)).size() > 0) {
            object = (IInventory)list.get(worldIn.field_73012_v.nextInt(list.size()));
        }
        return object;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77960_j() != stack2.func_77960_j() ? false : (stack1.field_77994_a > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    public double func_96107_aA() {
        return this.field_174879_c.func_177958_n();
    }

    public double func_96109_aB() {
        return this.field_174879_c.func_177956_o();
    }

    public double func_96108_aC() {
        return this.field_174879_c.func_177952_p();
    }

    public void setTransferCooldown(int ticks) {
        this.transferCooldown = ticks;
    }

    public boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public boolean mayTransfer() {
        return this.transferCooldown <= 1;
    }

    public String func_174875_k() {
        return "hopperducts:gratedhopper";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerGratedHopper(playerInventory, (IInventory)this, playerIn);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    private boolean isValidFilterItem(ItemStack itemstack) {
        for (int n = 5; n < 10; ++n) {
            if (this.inventory[n] == null || this.inventory[n].func_77973_b() != itemstack.func_77973_b() || this.inventory[n].func_77952_i() != itemstack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return slots_inventory;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        int j = -1;
        if (direction != null) {
            j = direction.ordinal();
        }
        if (j == -1 || j == 1) {
            return this.isValidFilterItem(itemStackIn);
        }
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return !this.isValidFilterItem(stack);
    }

    protected IItemHandler createInvHandler() {
        return new InvWrapper((IInventory)this){

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                ItemStack stack = this.getStackInSlot(slot);
                if (stack != null && TileEntityGratedHopper.this.isValidFilterItem(stack)) {
                    return null;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createInvHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }
}

