/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.core.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;

public class GuiHelper {
    private static final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

    public static void drawItemStackWithSlot(TextureManager textureManager, ItemStack itemStack, int x, int y) {
        GuiHelper.drawItemStackSlot(textureManager, x, y);
        if (itemStack != null && itemStack.func_77973_b() != null) {
            GuiHelper.drawItemStack(itemStack, x + 2, y + 2);
        }
    }

    public static void drawItemStackSlot(TextureManager textureManager, int x, int y) {
        textureManager.func_110577_a(Gui.field_110323_l);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        double uScale = 0.0078125;
        double vScale = 0.0078125;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GuiHelper.drawTexturedRectangle(buffer, x + 1, y + 1, x + 1 + 18, y + 1 + 18, 0.0, 0.0, 0.0, 0.140625, 0.140625);
        tessellator.func_78381_a();
    }

    public static void drawItemStack(ItemStack itemStack, int x, int y) {
        GlStateManager.func_179091_B();
        RenderHelper.func_74520_c();
        renderItem.func_175042_a(itemStack, x, y);
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
    }

    public static void drawTexturedRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, double u0, double v0, double u1, double v1) {
        buffer.func_181662_b(x0, y0, z).func_187315_a(u0, v0).func_181675_d();
        buffer.func_181662_b(x0, y1, z).func_187315_a(u0, v1).func_181675_d();
        buffer.func_181662_b(x1, y1, z).func_187315_a(u1, v1).func_181675_d();
        buffer.func_181662_b(x1, y0, z).func_187315_a(u1, v0).func_181675_d();
    }

    public static void drawTexturedRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, double textureWidth, double textureHeight, int argb) {
        double u0 = x0 / textureWidth;
        double v0 = y0 / textureHeight;
        double u1 = x1 / textureWidth;
        double v1 = y1 / textureHeight;
        GuiHelper.drawTexturedRectangle(buffer, x0, y0, x1, y1, z, u0, v0, u1, v1, argb);
    }

    public static void drawTexturedRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, double u0, double v0, double u1, double v1, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        GuiHelper.drawTexturedRectangle(buffer, x0, y0, x1, y1, z, u0, v0, u1, v1, r, g, b, a);
    }

    public static void drawTexturedRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, double u0, double v0, double u1, double v1, int r, int g, int b, int a) {
        buffer.func_181662_b(x0, y0, z).func_187315_a(u0, v0).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x0, y1, z).func_187315_a(u0, v1).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1, y1, z).func_187315_a(u1, v1).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1, y0, z).func_187315_a(u1, v0).func_181669_b(r, g, b, a).func_181675_d();
    }

    public static void drawColoredRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        GuiHelper.drawColoredRectangle(buffer, x0, y0, x1, y1, z, r, g, b, a);
    }

    public static void drawColoredRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, int r, int g, int b, int a) {
        buffer.func_181662_b(x0, y0, z).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x0, y1, z).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1, y1, z).func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b(x1, y0, z).func_181669_b(r, g, b, a).func_181675_d();
    }

    public static void drawVerticalGradientRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        GuiHelper.drawVerticalGradientRectangle(buffer, x0, y0, x1, y1, z, sr, sg, sb, sa, er, eg, eb, ea);
    }

    public static void drawVerticalGradientRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, int sr, int sg, int sb, int sa, int er, int eg, int eb, int ea) {
        buffer.func_181662_b(x0, y0, z).func_181669_b(sr, sg, sb, sa).func_181675_d();
        buffer.func_181662_b(x0, y1, z).func_181669_b(er, eg, eb, ea).func_181675_d();
        buffer.func_181662_b(x1, y1, z).func_181669_b(er, eg, eb, ea).func_181675_d();
        buffer.func_181662_b(x1, y0, z).func_181669_b(sr, sg, sb, sa).func_181675_d();
    }

    public static void drawHorizontalGradientRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        GuiHelper.drawHorizontalGradientRectangle(buffer, x0, y0, x1, y1, z, sr, sg, sb, sa, er, eg, eb, ea);
    }

    public static void drawHorizontalGradientRectangle(VertexBuffer buffer, double x0, double y0, double x1, double y1, double z, int sr, int sg, int sb, int sa, int er, int eg, int eb, int ea) {
        buffer.func_181662_b(x0, y0, z).func_181669_b(sr, sg, sb, sa).func_181675_d();
        buffer.func_181662_b(x0, y1, z).func_181669_b(sr, sg, sb, sa).func_181675_d();
        buffer.func_181662_b(x1, y1, z).func_181669_b(er, eg, eb, ea).func_181675_d();
        buffer.func_181662_b(x1, y0, z).func_181669_b(er, eg, eb, ea).func_181675_d();
    }
}

