/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.multiblock.solar;

import com.valkyrieofnight.environmentaltech.api.modifier.IModifierBlock;
import com.valkyrieofnight.environmentaltech.block.multiblock.solar.BlockSolar;
import com.valkyrieofnight.environmentaltech.modifier.ModifierHandler;
import com.valkyrieofnight.valkyrielib.energy.EnergyProvider;
import com.valkyrieofnight.valkyrielib.energy.EnergyUtil;
import com.valkyrieofnight.valkyrielib.energy.IEnergyProvider;
import com.valkyrieofnight.valkyrielib.multiblock.VLTileController;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class TileContSolarBase
extends VLTileController {
    public static int PRODUCTION_RATE = 80;
    protected List<BlockPos> modifiers;
    protected ModifierHandler modifierHandler;
    protected ContinuousSolarScanner solarScanner;
    protected EnergyProvider eBuffer;
    protected int totalCanSeeSky = 0;

    public static int getMultiplier(int tier) {
        if (tier <= 0) {
            return 1;
        }
        return (int)Math.pow(2.0, tier - 1);
    }

    public static int getCellGen(int tier) {
        return PRODUCTION_RATE * TileContSolarBase.getMultiplier(tier);
    }

    public static int getArrayGen(int tier, int totalCells) {
        return TileContSolarBase.getCellGen(tier) * totalCells;
    }

    public TileContSolarBase(int rft) {
        this.eBuffer = new EnergyProvider(this.getBaseDuration() * rft);
        this.modifiers = new ArrayList<BlockPos>();
        this.modifierHandler = new ModifierHandler();
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.handleEnergy();
            if (this.isFormed()) {
                if (this.solarScanner == null) {
                    this.solarScanner = new ContinuousSolarScanner(this, this.getScanRate());
                }
                this.solarScanner.update();
            }
        }
    }

    protected abstract int getScanRate();

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.eBuffer.writeToNBT(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.eBuffer.readFromNBT(nbt);
    }

    public void handleEnergy() {
        EnergyUtil.sendEnergyToFirst((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IEnergyProvider)this.eBuffer, (EnumFacing[])this.validEnergyDirections());
    }

    public boolean canProcess() {
        if (this.modifiers.isEmpty()) {
            this.modifiers = this.getStructure().getSlavesOfType(IModifierBlock.class, this.func_174877_v(), this.getMBDirectionE());
            ArrayList<IModifierBlock> mods = new ArrayList<IModifierBlock>();
            for (BlockPos mbp : this.modifiers) {
                Block blk = this.field_145850_b.func_180495_p(mbp).func_177230_c();
                if (!(blk instanceof IModifierBlock)) continue;
                mods.add((IModifierBlock)blk);
            }
            this.modifierHandler.setModifiers(mods);
            this.modifierHandler.calculateAttributeMultipliers();
        }
        return true;
    }

    public int getBaseDuration() {
        return 10;
    }

    public void deformMultiblock() {
        super.deformMultiblock();
        this.modifiers = new ArrayList<BlockPos>();
        this.modifierHandler = new ModifierHandler();
    }

    public void onProcessTick() {
        this.genEnergy();
    }

    public void onIdleTick() {
    }

    protected void genEnergy() {
        int totalRF = 0;
        if (this.field_145850_b.func_72935_r()) {
            totalRF = (int)((float)totalRF + (float)(this.getRFTPerCell() * this.totalCanSeeSky) * this.field_145850_b.getSunBrightnessFactor(1.0f));
        }
        if ((this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I()) && this.modifierHandler.hasAttribute("piezo")) {
            totalRF = (int)((float)totalRF + (float)(this.getRFTPerCell() * this.totalCanSeeSky / 64) * this.modifierHandler.getAttributeMultiplier("piezo") * this.field_145850_b.func_72867_j(1.0f) * (1.0f + this.field_145850_b.func_72819_i(2.0f)));
        }
        this.eBuffer.receiveEnergyInternal(totalRF, false);
    }

    protected abstract int getRFTPerCell();

    public void onProcessComplete() {
        this.genEnergy();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.eBuffer;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IEnergyProvider getEnergyProvider() {
        return this.eBuffer;
    }

    public float getSpeedMultiplier() {
        return 1.0f;
    }

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }

    public EnumFacing[] validEnergyDirections() {
        return new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.DOWN};
    }

    protected void setTotalValidSolars(int valid) {
        this.totalCanSeeSky = valid;
    }

    protected List<BlockPos> getAllCells() {
        return this.getStructure().getSlavesOfType(BlockSolar.class, this.func_174877_v(), this.getMBDirectionE());
    }

    protected static class ContinuousSolarScanner {
        private TileContSolarBase solarCont;
        private Queue<BlockPos> queue = new LinkedList<BlockPos>();
        private World world;
        private int scanRate;
        private int totalValid = 0;

        public ContinuousSolarScanner(TileContSolarBase cont, int scanRate) {
            this.solarCont = cont;
            this.scanRate = scanRate;
            this.world = cont.func_145831_w();
        }

        public void update() {
            for (int i = 0; i < this.scanRate; ++i) {
                if (!this.checkValid()) continue;
                ++this.totalValid;
            }
        }

        protected boolean checkValid() {
            BlockPos pos;
            if (this.queue.isEmpty()) {
                this.startQueue();
            }
            return this.world.func_175710_j((pos = this.queue.poll()).func_177972_a(EnumFacing.UP));
        }

        public void setScanRate(int scanRate) {
            this.scanRate = scanRate;
        }

        protected void startQueue() {
            this.solarCont.setTotalValidSolars(this.totalValid);
            this.totalValid = 0;
            this.queue.clear();
            this.queue.addAll(this.solarCont.getAllCells());
        }
    }
}

