/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.multiblock.nanobotbeacon;

import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.environmentaltech.api.modifier.IModifierBlock;
import com.valkyrieofnight.environmentaltech.modifier.ETModifierAttributes;
import com.valkyrieofnight.environmentaltech.modifier.ModifierHandler;
import com.valkyrieofnight.environmentaltech.network.PacketDispatcher;
import com.valkyrieofnight.environmentaltech.network.packets.nanobotbeacon.PacketNBBClientFlight;
import com.valkyrieofnight.environmentaltech.network.packets.nanobotbeacon.PacketNBBClientUpdate;
import com.valkyrieofnight.valkyrielib.energy.EnergyReceiver;
import com.valkyrieofnight.valkyrielib.energy.IEnergyReceiver;
import com.valkyrieofnight.valkyrielib.multiblock.VLTileController;
import com.valkyrieofnight.valkyrielib.util.helpers.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class TileContNBBBase
extends VLTileController {
    private static final float DEF_WALK_SPEED = 0.1f;
    private static final float DEF_FLY_SPEED = 0.05f;
    private GameProfile player;
    private EnergyReceiver eBuffer;
    private ModifierHandler modifierHandler;
    private List<BlockPos> modifiers;
    private boolean dealsWithFlight = false;
    private boolean markNeedsToUpdatePlayer = false;

    public TileContNBBBase(int eBuffSize) {
        this.eBuffer = new EnergyReceiver(eBuffSize);
        this.modifierHandler = new ModifierHandler();
        this.modifiers = new ArrayList<BlockPos>();
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            // empty if block
        }
    }

    private void addPlayerEffects() {
        EntityPlayer plr;
        if (this.player != null && PlayerUtil.doesPlayerExist((World)this.field_145850_b, (UUID)this.player.getId()) && (plr = PlayerUtil.getPlayerFromWorld((World)this.field_145850_b, (UUID)this.player.getId())) != null) {
            int potionDuration = this.getBaseDuration() * 2 + 300;
            if (this.modifierHandler != null) {
                int ecost = (int)this.modifierHandler.getAttributeMultiplier("energycost_fixed") * this.getBaseDuration();
                if (this.eBuffer.getEnergyStored() >= ecost) {
                    this.eBuffer.extractEnergyInternal(ecost, false);
                    if (this.modifierHandler.hasAttribute(ETModifierAttributes.E_FLIGHT_CREATIVE.getAttributeName())) {
                        this.dealsWithFlight = true;
                        plr.field_71075_bZ.field_75101_c = true;
                        PacketDispatcher.DISPATCHER.sendToAllAround((IMessage)new PacketNBBClientFlight(this.player.getId(), true), plr, 1.0);
                    } else if (this.dealsWithFlight) {
                        PacketDispatcher.DISPATCHER.sendToAllAround((IMessage)new PacketNBBClientFlight(this.player.getId(), false), plr, 1.0);
                        plr.field_71075_bZ.field_75101_c = false;
                        this.dealsWithFlight = false;
                    }
                    this.addPotionEffect(plr, ETModifierAttributes.P_SPEED.getAttributeName(), potionDuration, MobEffects.field_76424_c);
                    this.addPotionEffect(plr, ETModifierAttributes.P_NIGHT_VISION.getAttributeName(), potionDuration, MobEffects.field_76439_r);
                    this.addPotionEffect(plr, ETModifierAttributes.P_HASTE.getAttributeName(), potionDuration, MobEffects.field_76422_e);
                    this.addPotionEffect(plr, ETModifierAttributes.P_STRENGTH.getAttributeName(), potionDuration, MobEffects.field_76420_g);
                    this.addPotionEffect(plr, ETModifierAttributes.P_WATER_BREATHING.getAttributeName(), potionDuration, MobEffects.field_76427_o);
                    this.addPotionEffect(plr, ETModifierAttributes.P_REGEN.getAttributeName(), potionDuration, MobEffects.field_76428_l);
                    this.addPotionEffect(plr, ETModifierAttributes.P_SATURATION.getAttributeName(), potionDuration, MobEffects.field_76443_y);
                    this.addPotionEffect(plr, ETModifierAttributes.P_RESISTANCE.getAttributeName(), potionDuration, MobEffects.field_76429_m);
                    this.addPotionEffect(plr, ETModifierAttributes.P_JUMP_BOOST.getAttributeName(), potionDuration, MobEffects.field_76430_j);
                    this.addPotionEffect(plr, ETModifierAttributes.P_FIRE_RESISTANCE.getAttributeName(), potionDuration, MobEffects.field_76426_n);
                } else {
                    this.removePlayerEffects();
                    this.markNeedsToUpdatePlayer = true;
                }
            }
        }
    }

    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
    }

    private void removePlayerEffects() {
        EntityPlayer plr;
        if (this.player != null && PlayerUtil.doesPlayerExist((World)this.field_145850_b, (UUID)this.player.getId()) && (plr = PlayerUtil.getPlayerFromWorld((World)this.field_145850_b, (UUID)this.player.getId())) != null && this.modifierHandler != null && this.modifierHandler.hasAttribute(ETModifierAttributes.E_FLIGHT_CREATIVE.getAttributeName())) {
            plr.field_71075_bZ.field_75101_c = false;
            this.updatePlayer(new PacketNBBClientFlight(this.player.getId(), false), plr);
        }
    }

    private void addPotionEffect(EntityPlayer plr, String pe, int potionDuration, Potion effect) {
        int level;
        if (this.modifierHandler.hasAttribute(pe) && (level = (int)Math.min(this.modifierHandler.getAttributeMultiplier(pe) - 1.0f, (float)(this.maxPotionLevel(pe) - 1))) >= 0) {
            plr.func_70690_d(new PotionEffect(effect, potionDuration, level, true, false));
        }
    }

    private void updatePlayer(PacketNBBClientFlight packet, EntityPlayer plr) {
        PacketDispatcher.DISPATCHER.sendToAllAround((IMessage)packet, plr, 1.0);
    }

    public void onChunkUnload() {
        this.removePlayerEffects();
        this.markNeedsToUpdatePlayer = true;
        super.onChunkUnload();
    }

    public void onLoad() {
        super.onLoad();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.eBuffer;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IEnergyReceiver getEnergyReceiver() {
        return this.eBuffer;
    }

    protected abstract boolean interDimensional();

    protected abstract int maxPotionLevel(String var1);

    public void setPlayer(EntityPlayer plr) {
        if (plr != null) {
            this.player = plr.func_146103_bH();
        }
    }

    public void setPlayer(UUID plr) {
        EntityPlayer pl = PlayerUtil.getPlayerFromWorld((World)this.field_145850_b, (UUID)plr);
        if (pl != null) {
            this.player = pl.func_146103_bH();
        }
    }

    public UUID getPlayerID() {
        return this.player.getId();
    }

    public GameProfile getPlayerProfile() {
        return this.player;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.player != null) {
            nbt.func_74782_a("profile", (NBTBase)PlayerUtil.proifleToNBT((GameProfile)this.player));
        }
        nbt.func_74757_a("dflight", this.dealsWithFlight);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.player = PlayerUtil.profileFromNBT((NBTTagCompound)nbt.func_74775_l("profile"));
        this.dealsWithFlight = nbt.func_74767_n("dflight");
    }

    public void updateClientWithPlayer() {
        if (this.player == null) {
            return;
        }
        if (PlayerUtil.doesPlayerExist((World)this.field_145850_b, (UUID)this.player.getId())) {
            PacketDispatcher.DISPATCHER.sendToAllAround((IMessage)new PacketNBBClientUpdate(this), PlayerUtil.getPlayerFromWorld((World)this.field_145850_b, (UUID)this.player.getId()), 8.0);
        }
    }

    public int getBaseDuration() {
        return 40;
    }

    public int getMinDuration() {
        return this.getBaseDuration();
    }

    public int getMaxDuration() {
        return this.getBaseDuration();
    }

    public float getSpeedMultiplier() {
        return 0.0f;
    }

    public boolean canProcess() {
        if (this.field_145850_b.field_72995_K) {
            System.out.println(this.player);
        }
        if (this.modifiers.isEmpty()) {
            this.modifiers = this.getStructure().getSlavesOfType(IModifierBlock.class, this.func_174877_v(), this.getMBDirectionE());
            ArrayList<IModifierBlock> mods = new ArrayList<IModifierBlock>();
            for (BlockPos mbp : this.modifiers) {
                Block blk = this.field_145850_b.func_180495_p(mbp).func_177230_c();
                if (!(blk instanceof IModifierBlock)) continue;
                mods.add((IModifierBlock)blk);
            }
            this.modifierHandler.setModifiers(mods);
            this.modifierHandler.calculateAttributeMultipliers();
        }
        return this.player != null;
    }

    public void deformMultiblock() {
        super.deformMultiblock();
        this.removePlayerEffects();
        this.modifiers = new ArrayList<BlockPos>();
        this.modifierHandler = new ModifierHandler();
        this.dealsWithFlight = false;
    }

    public void onProcessTick() {
    }

    public void onProcessComplete() {
        this.addPlayerEffects();
    }

    public void onIdleTick() {
        if (this.func_145831_w().func_72820_D() % 40L == 0L) {
            this.removePlayerEffects();
        }
    }
}

