/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.tileentity.chunkloaders;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.mojang.authlib.GameProfile;
import com.valkyrieofnight.environmentaltech.EnvironmentalTech;
import com.valkyrieofnight.valkyrielib.util.helpers.PlayerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerLoaderManager
implements ForgeChunkManager.LoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private static PlayerLoaderManager instance;
    private static Map<World, Map<GameProfile, ForgeChunkManager.Ticket>> playerTickets;
    private boolean dirty = false;

    private PlayerLoaderManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)EnvironmentalTech.instance, (ForgeChunkManager.LoadingCallback)this);
    }

    public static PlayerLoaderManager getInstance() {
        if (instance == null) {
            instance = new PlayerLoaderManager();
        }
        return instance;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return tickets;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        this.dirty = true;
        HashMap<GameProfile, ForgeChunkManager.Ticket> cache = new HashMap<GameProfile, ForgeChunkManager.Ticket>();
        playerTickets.put(world, cache);
        for (ForgeChunkManager.Ticket ticket : tickets) {
            NBTTagCompound data = ticket.getModData();
            GameProfile prof = PlayerUtil.profileFromNBT((NBTTagCompound)data);
            cache.put(prof, ticket);
            NBTTagList list = ticket.getModData().func_150295_c("chunks", 4);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagLong pos = (NBTTagLong)list.func_179238_g(i);
                ChunkPos cp = PlayerLoaderManager.deserializeChunkPos(pos.func_150291_c());
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)cp);
                Chunk chunk = world.func_72964_e(cp.field_77276_a, cp.field_77275_b);
            }
        }
    }

    private Map<GameProfile, ForgeChunkManager.Ticket> getWorldTickets(World world) {
        if (world.field_72995_K) {
            return null;
        }
        if (!playerTickets.containsKey(world)) {
            playerTickets.put(world, new HashMap());
        }
        return playerTickets.get(world);
    }

    @SubscribeEvent
    public void unloadWorldEvent(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (playerTickets.containsKey(event.getWorld())) {
            playerTickets.remove(event.getWorld());
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (this.dirty) {
            for (Map<GameProfile, ForgeChunkManager.Ticket> map : playerTickets.values()) {
                for (ForgeChunkManager.Ticket tick : map.values()) {
                    ImmutableSet chunkList = tick.getChunkList();
                    for (ChunkPos chunkPos : chunkList) {
                        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)tick, (ChunkPos)chunkPos);
                    }
                }
            }
            this.dirty = false;
        }
    }

    public ForgeChunkManager.Ticket getPlayerTicket(GameProfile profile, World world) {
        ForgeChunkManager.Ticket tick;
        HashMap<GameProfile, ForgeChunkManager.Ticket> tickMap = (HashMap<GameProfile, ForgeChunkManager.Ticket>)playerTickets.get(world);
        if (tickMap == null) {
            tickMap = new HashMap<GameProfile, ForgeChunkManager.Ticket>();
            playerTickets.put(world, tickMap);
        }
        if ((tick = (ForgeChunkManager.Ticket)tickMap.get(profile)) == null) {
            tick = ForgeChunkManager.requestPlayerTicket((Object)EnvironmentalTech.instance, (String)profile.getName(), (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            PlayerUtil.writeProfileToNBT((GameProfile)profile, (NBTTagCompound)tick.getModData());
            tickMap.put(profile, tick);
        }
        return tick;
    }

    public void addToTicket(ForgeChunkManager.Ticket tick, ChunkPos chunk) {
        if (tick.getChunkList().contains((Object)chunk)) {
            return;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)tick, (ChunkPos)chunk);
        NBTTagList list = tick.getModData().func_150295_c("chunks", 4);
        if (!tick.getModData().func_150297_b("chunks", 9)) {
            tick.getModData().func_74782_a("chunks", (NBTBase)list);
        }
        tick.getModData().func_74782_a("chunks", (NBTBase)list);
        list.func_74742_a((NBTBase)new NBTTagLong(PlayerLoaderManager.serializeChunkPos(chunk)));
    }

    public void removeFromTicket(ForgeChunkManager.Ticket tick, ChunkPos chunk) {
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)tick, (ChunkPos)chunk);
        NBTTagList list = tick.getModData().func_150295_c("chunks", 4);
        long chunkPos = PlayerLoaderManager.serializeChunkPos(chunk);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagLong pos = (NBTTagLong)list.func_179238_g(i);
            if (pos.func_150291_c() != chunkPos) continue;
            list.func_74744_a(i--);
        }
    }

    public void removeTicket(ForgeChunkManager.Ticket tick) {
        NBTTagList list = tick.getModData().func_150295_c("chunks", 4);
        if (list.func_74745_c() > 0) {
            return;
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)tick);
        this.getWorldTickets(tick.world).remove(tick);
    }

    public boolean isLoading(ForgeChunkManager.Ticket tick, ChunkPos chunk) {
        if (tick == null || chunk == null) {
            return false;
        }
        NBTTagList list = tick.getModData().func_150295_c("chunks", 4);
        long chunkPos = PlayerLoaderManager.serializeChunkPos(chunk);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagLong pos = (NBTTagLong)list.func_179238_g(i);
            if (pos.func_150291_c() != chunkPos) continue;
            return true;
        }
        return false;
    }

    public static long serializeChunkPos(ChunkPos chunk) {
        return chunk.field_77276_a & 0xFFFFFFFF | (chunk.field_77275_b & 0xFFFFFFFF) << 32;
    }

    public static ChunkPos deserializeChunkPos(long value) {
        return new ChunkPos((int)(value & 0xFFFFFFFFFFFFFFFFL), (int)(value >> 32));
    }

    public static ChunkPos getChunkPos(BlockPos pos) {
        return new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    static {
        playerTickets = new HashMap<World, Map<GameProfile, ForgeChunkManager.Ticket>>();
    }
}

