/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.registry;

import com.valkyrieofnight.environmentaltech.api.registry.IFocusableRegistry;
import com.valkyrieofnight.environmentaltech.api.util.WeightedRandomUtil;
import com.valkyrieofnight.environmentaltech.api.util.WeightedStackBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;

public class FocusableRegistry
implements IFocusableRegistry {
    private ArrayList<WeightedStackBase> oreStacks = new ArrayList();
    private HashMap<EnumDyeColor, List<ItemStack>> priorityOres = new HashMap();

    protected FocusableRegistry() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            this.priorityOres.put(color, new ArrayList());
        }
    }

    @Override
    public boolean hasResource(ItemStack other) {
        for (WeightedStackBase stack : this.oreStacks) {
            if (!stack.isStackEqual(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addResource(WeightedStackBase stack, EnumDyeColor prioritized) {
        if (!this.hasResource(stack.getMainStack()) && stack.getMainStack() != null) {
            this.oreStacks.add(stack);
            List<ItemStack> stacks = this.priorityOres.get(prioritized);
            stacks.add(stack.getMainStack());
        }
        return false;
    }

    private List<ItemStack> valuesOfFocus(EnumDyeColor focus) {
        return this.priorityOres.get(focus);
    }

    @Override
    public List<WeightedStackBase> getFocusedList(EnumDyeColor focusColor, float boostMultiplier) {
        ArrayList<WeightedStackBase> wisl = new ArrayList<WeightedStackBase>(this.oreStacks.size());
        WeightedRandomUtil.copyWSList(wisl, this.oreStacks);
        ArrayList addedOres = new ArrayList();
        List<ItemStack> sedco = this.valuesOfFocus(focusColor);
        int boost = WeightedRandom.func_76272_a(this.oreStacks) / (this.oreStacks.size() / 2);
        for (ItemStack string : sedco) {
            for (WeightedStackBase stack : wisl) {
                if (!stack.isStackEqual(string)) continue;
                stack.field_76292_a = (int)((float)stack.field_76292_a + (float)boost * MathHelper.func_76135_e((float)boostMultiplier));
            }
        }
        return wisl;
    }

    @Override
    public List<WeightedStackBase> getUnFocusedList() {
        return this.oreStacks;
    }

    @Override
    public EnumDyeColor getPrioritizedLens(ItemStack stack) {
        for (EnumDyeColor dye : this.priorityOres.keySet()) {
            List<ItemStack> ores = this.priorityOres.get(dye);
            for (ItemStack string : ores) {
                if (!string.equals(stack)) continue;
                return dye;
            }
        }
        return null;
    }

    @Override
    public WeightedStackBase getWeightedStack(ItemStack stack) {
        for (WeightedStackBase weightedOreItemStack : this.oreStacks) {
            if (!weightedOreItemStack.isStackEqual(stack)) continue;
            return weightedOreItemStack;
        }
        return null;
    }
}

