/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.environmentaltech.init;

import com.valkyrieofnight.environmentaltech.api.registry.ETRegistries;
import com.valkyrieofnight.environmentaltech.api.registry.IFocusableRegistry;
import com.valkyrieofnight.environmentaltech.init.ETBlocks;
import com.valkyrieofnight.environmentaltech.init.ETItems;
import com.valkyrieofnight.environmentaltech.registry.focusablejson.FocusableJsonHandler;
import com.valkyrieofnight.environmentaltech.registry.terraformer.TerraformerSoftwareRegistry;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwareDeforrest;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwareGrassGrower;
import com.valkyrieofnight.environmentaltech.registry.terraformer.software.SoftwarePlantRemover;
import java.io.File;
import net.minecraft.item.EnumDyeColor;

public class ETCommonRecipes {
    private static ETBlocks etb;
    private static ETItems eti;
    private static TerraformerSoftwareRegistry tfr;

    public static void preInit() {
        tfr.registerSoftware(SoftwareDeforrest.getInstance());
        tfr.registerSoftware(SoftwarePlantRemover.getInstance());
        tfr.registerSoftware(SoftwareGrassGrower.getInstance());
    }

    public static void initialize() {
    }

    public static void postInit() {
        File expl = new File("config/environmentaltech/void_miner_example.json");
        if (!expl.exists()) {
            FocusableJsonHandler.FocusableList efl = new FocusableJsonHandler.FocusableList();
            efl.addEntry(new FocusableJsonHandler.FocusableItem("minecraft:diamond", 0, EnumDyeColor.CYAN, 1000));
            efl.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:stone", 3, EnumDyeColor.GRAY, 1000));
            efl.addEntry(new FocusableJsonHandler.FocusableOre("oreIron", EnumDyeColor.WHITE, 1000));
            FocusableJsonHandler.saveRegistryDefaultsToJson(expl, efl);
        }
        ETCommonRecipes.addVoidOreMinerRecipes();
        ETCommonRecipes.addVoidResMinerRecipes();
    }

    public static void addVoidOreMinerRecipes() {
        IFocusableRegistry reg = ETRegistries.voidOreMinerRegistry;
        File file = new File("config/environmentaltech/void_ore_miner/minable.json");
        if (file.exists()) {
            FocusableJsonHandler.FocusableList focusableList = FocusableJsonHandler.loadRegistryFromJson(file, reg);
        } else {
            FocusableJsonHandler.FocusableList defaults = new FocusableJsonHandler.FocusableList();
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreCoal", EnumDyeColor.BLACK, 40));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreIron", EnumDyeColor.WHITE, 32));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreQuartz", EnumDyeColor.WHITE, 20));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreRedstone", EnumDyeColor.RED, 20));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreLapis", EnumDyeColor.BLUE, 16));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreGold", EnumDyeColor.YELLOW, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreDiamond", EnumDyeColor.CYAN, 11));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreEmerald", EnumDyeColor.LIME, 5));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("glowstone", EnumDyeColor.YELLOW, 7));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("shardLonsdaleite", EnumDyeColor.BLACK, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreCopper", EnumDyeColor.ORANGE, 26));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreTin", EnumDyeColor.GRAY, 26));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreSilver", EnumDyeColor.SILVER, 20));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreLead", EnumDyeColor.PURPLE, 22));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreAluminum", EnumDyeColor.WHITE, 20));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreUranium", EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreYellorite", EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreCertusQuartz", EnumDyeColor.LIGHT_BLUE, 8));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreChargedCertusQuartz", EnumDyeColor.LIGHT_BLUE, 4));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreCinnabar", EnumDyeColor.BROWN, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreAmber", EnumDyeColor.ORANGE, 9));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreNickel", EnumDyeColor.GRAY, 9));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("orePlatinum", EnumDyeColor.LIGHT_BLUE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreMithril", EnumDyeColor.LIGHT_BLUE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreSulfur", EnumDyeColor.YELLOW, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreNiter", EnumDyeColor.WHITE, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreSaltpeter", EnumDyeColor.WHITE, 8));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreFirestone", EnumDyeColor.RED, 4));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreCobalt", EnumDyeColor.BLUE, 7));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreArdite", EnumDyeColor.ORANGE, 7));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreApatite", EnumDyeColor.LIGHT_BLUE, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreDraconium", EnumDyeColor.PURPLE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreGraphite", EnumDyeColor.BLACK, 12));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreQuartzBlack", EnumDyeColor.BLACK, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreRuby", EnumDyeColor.RED, 8));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("orePeridot", EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreTopaz", EnumDyeColor.ORANGE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreTanzanite", EnumDyeColor.PURPLE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreMalachite", EnumDyeColor.CYAN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreSapphire", EnumDyeColor.BLUE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreGarnet", EnumDyeColor.ORANGE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreHeliodore", EnumDyeColor.YELLOW, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreBeryl", EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreIndicolite", EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreAquamarine", EnumDyeColor.BLUE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreIolite", EnumDyeColor.PURPLE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreAmethyst", EnumDyeColor.PURPLE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreAgate", EnumDyeColor.PINK, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreMorganite", EnumDyeColor.PINK, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreOnyx", EnumDyeColor.BLACK, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreOpal", EnumDyeColor.WHITE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreCarnelian", EnumDyeColor.RED, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreSpinel", EnumDyeColor.BROWN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreCitrine", EnumDyeColor.BROWN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreJasper", EnumDyeColor.YELLOW, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreGoldenBeryl", EnumDyeColor.YELLOW, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreMoldavite", EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreTurquoise", EnumDyeColor.CYAN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreMoonstone", EnumDyeColor.CYAN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreBlueTopaz", EnumDyeColor.BLUE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreVioletSapphire", EnumDyeColor.PURPLE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreLepidolite", EnumDyeColor.PURPLE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreAmetrine", EnumDyeColor.PURPLE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreBlackDiamond", EnumDyeColor.BLACK, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreAlexandrite", EnumDyeColor.WHITE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreChaos", EnumDyeColor.WHITE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreEnderEssence", EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreResonating", EnumDyeColor.BROWN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreZinc", EnumDyeColor.PINK, 9));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreIridium", EnumDyeColor.WHITE, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreTungsten", EnumDyeColor.BLACK, 8));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreOsmium", EnumDyeColor.SILVER, 8));
            defaults.addEntry(new FocusableJsonHandler.FocusableOre("oreSalt", EnumDyeColor.WHITE, 3));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("rftools:dimensional_shard_ore", 0, EnumDyeColor.WHITE, 4));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("mysticalagriculture:inferium_ore", 0, EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("mysticalagriculture:prosperity_ore", 0, EnumDyeColor.SILVER, 4));
            FocusableJsonHandler.saveRegistryDefaultsToJson(file, defaults);
            FocusableJsonHandler.loadIntoRegistry(defaults, reg);
        }
    }

    public static void addVoidResMinerRecipes() {
        IFocusableRegistry reg = ETRegistries.voidResMinerRegistry;
        File file = new File("config/environmentaltech/void_resource_miner/minable.json");
        if (file.exists()) {
            FocusableJsonHandler.loadRegistryFromJson(file, reg);
        } else {
            FocusableJsonHandler.FocusableList defaults = new FocusableJsonHandler.FocusableList();
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:stone", 0, EnumDyeColor.GRAY, 16));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:stone", 1, EnumDyeColor.PINK, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:stone", 3, EnumDyeColor.WHITE, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:stone", 5, EnumDyeColor.GRAY, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:gravel", 0, EnumDyeColor.SILVER, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:grass", 0, EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:dirt", 0, EnumDyeColor.BROWN, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:dirt", 2, EnumDyeColor.BROWN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:sand", 0, EnumDyeColor.YELLOW, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:sand", 1, EnumDyeColor.YELLOW, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:cobblestone", 0, EnumDyeColor.GRAY, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:mossy_cobblestone", 0, EnumDyeColor.GREEN, 6));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:obsidian", 0, EnumDyeColor.PURPLE, 5));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:clay", 0, EnumDyeColor.SILVER, 7));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:netherrack", 0, EnumDyeColor.RED, 14));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:soul_sand", 0, EnumDyeColor.BROWN, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:mycelium", 0, EnumDyeColor.PURPLE, 4));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:end_stone", 0, EnumDyeColor.WHITE, 7));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:hardened_clay", 0, EnumDyeColor.RED, 6));
            for (EnumDyeColor dye : EnumDyeColor.values()) {
                defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:stained_hardened_clay", dye.func_176765_a(), dye, 1));
            }
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("minecraft:sponge", 0, EnumDyeColor.YELLOW, 2));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("environmentaltech:alabaster", 0, EnumDyeColor.WHITE, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("environmentaltech:basalt", 0, EnumDyeColor.BLACK, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("environmentaltech:hardened_stone", 0, EnumDyeColor.GRAY, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("environmentaltech:mica", 0, EnumDyeColor.WHITE, 2));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("chisel:limestoneextra", 7, EnumDyeColor.LIME, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("chisel:marbleextra", 7, EnumDyeColor.WHITE, 10));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_dirt", 0, EnumDyeColor.GREEN, 2));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_dirt", 1, EnumDyeColor.BLUE, 2));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_dirt", 2, EnumDyeColor.PURPLE, 2));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_dirt", 3, EnumDyeColor.ORANGE, 2));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 1, EnumDyeColor.GREEN, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 2, EnumDyeColor.BLUE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 3, EnumDyeColor.PURPLE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 4, EnumDyeColor.ORANGE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 6, EnumDyeColor.GREEN, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 7, EnumDyeColor.BLUE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 8, EnumDyeColor.PURPLE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 9, EnumDyeColor.ORANGE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 11, EnumDyeColor.GREEN, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 12, EnumDyeColor.BLUE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 13, EnumDyeColor.PURPLE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("tconstruct:slime_grass", 14, EnumDyeColor.ORANGE, 1));
            defaults.addEntry(new FocusableJsonHandler.FocusableBlock("appliedenergistics2:sky_stone_block", 0, EnumDyeColor.BLACK, 2));
            FocusableJsonHandler.saveRegistryDefaultsToJson(file, defaults);
            FocusableJsonHandler.loadIntoRegistry(defaults, reg);
        }
    }

    static {
        tfr = TerraformerSoftwareRegistry.getInstance();
    }
}

