/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public final class MetaItem {
    public static final FMLControlledNamespacedRegistry<Item> itemRegistry = (FMLControlledNamespacedRegistry)GameRegistry.findRegistry(Item.class);

    private MetaItem() {
    }

    public static int get(ItemStack itemStack) {
        Item item;
        if (itemStack == null || (item = itemStack.func_77973_b()) == null) {
            return 0;
        }
        int id = itemRegistry.getId((IForgeRegistryEntry)item);
        return id > 0 ? (item.getDamage(itemStack) == Short.MAX_VALUE ? id : id | item.getDamage(itemStack) + 1 << 16) : 0;
    }

    public static int get(Item item) {
        if (item == null) {
            return 0;
        }
        int id = itemRegistry.func_148757_b((Object)item);
        return id > 0 ? id | 0x10000 : 0;
    }

    public static ItemStack toItemStack(int metaItemKey) {
        return metaItemKey > 0 ? new ItemStack((Item)itemRegistry.getRaw(metaItemKey ^ metaItemKey & 0x10000), 0, metaItemKey >> 16) : null;
    }

    public static int getCumulative(ItemStack ... itemStacks) {
        int cumulativeKey = 0;
        for (ItemStack itemStack : itemStacks) {
            cumulativeKey += MetaItem.get(itemStack);
        }
        return cumulativeKey;
    }

    public static int[] getArray(Collection<ItemStack> itemStackCollection) {
        return MetaItem.getList(itemStackCollection).toArray();
    }

    public static TIntList getList(Collection<ItemStack> itemStackCollection) {
        TIntArrayList keys = new TIntArrayList();
        for (ItemStack itemStack : itemStackCollection) {
            int hash = MetaItem.get(itemStack);
            if (hash == 0) continue;
            keys.add(hash);
        }
        return keys;
    }

    public static TIntSet getSet(Collection<ItemStack> itemStackCollection) {
        return new TIntHashSet((TIntCollection)MetaItem.getList(itemStackCollection));
    }

    public static <E> void populateMap(Collection<ItemStack> itemStackCollection, TIntObjectMap<E> map, E defaultValue) {
        for (int id : MetaItem.getArray(itemStackCollection)) {
            map.put(id, defaultValue);
        }
    }

    public static void populateMap(Collection<ItemStack> itemStackCollection, TIntLongMap map, long defaultValue) {
        for (int id : MetaItem.getArray(itemStackCollection)) {
            map.put(id, defaultValue);
        }
    }

    public static TIntIntMap getKeySizeMap(int startIndex, int endIndex, @Nonnull ItemStack[] itemStacks) {
        TIntIntHashMap keySizeMap = new TIntIntHashMap();
        for (int i = startIndex; i < endIndex; ++i) {
            if (itemStacks[i] == null) continue;
            int key = MetaItem.get(itemStacks[i]);
            if (keySizeMap.containsKey(key)) {
                keySizeMap.put(key, keySizeMap.get(key) + 1);
                continue;
            }
            keySizeMap.put(key, 1);
        }
        return keySizeMap;
    }

    public static TIntIntMap getSmartKeySizeMap(int startIndex, int endIndex, @Nonnull ItemStack[] itemStacks) {
        TIntIntHashMap smartKeySizeMap = new TIntIntHashMap();
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack itemStack = itemStacks[i];
            if (itemStack == null) continue;
            int key = MetaItem.get(itemStack);
            if (smartKeySizeMap.containsKey(key)) {
                smartKeySizeMap.put(key, smartKeySizeMap.get(key) + itemStack.field_77994_a);
                continue;
            }
            smartKeySizeMap.put(key, itemStack.field_77994_a);
        }
        return smartKeySizeMap;
    }
}

