/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.network;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mcmultipart.network.MessageMultipartChange;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.MutableTriple;

public class MessageSplit
implements IMessage,
IMessageHandler<MessageSplit, MessageSplit> {
    private static final Cache<UUID, MutableTriple<Integer, Integer, byte[][]>> cache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private UUID id;
    private int packets;
    private int index;
    private byte[] data;

    MessageSplit(UUID id, int packets, int index, byte[] data) {
        this.id = id;
        this.packets = packets;
        this.index = index;
        this.data = data;
    }

    public MessageSplit() {
    }

    public MessageSplit onMessage(final MessageSplit message, MessageContext ctx) {
        try {
            MutableTriple triple = (MutableTriple)cache.get((Object)message.id, (Callable)new Callable<MutableTriple<Integer, Integer, byte[][]>>(){

                @Override
                public MutableTriple<Integer, Integer, byte[][]> call() throws Exception {
                    return MutableTriple.of((Object)message.packets, (Object)0, (Object)new byte[message.packets][]);
                }
            });
            ((byte[][])triple.right)[message.index] = message.data;
            MutableTriple mutableTriple = triple;
            Integer n = (Integer)mutableTriple.middle;
            mutableTriple.middle = (Integer)mutableTriple.middle + 1;
            Integer n2 = mutableTriple.middle;
            if (triple.middle == triple.left) {
                MessageMultipartChange packet = new MessageMultipartChange();
                packet.fromBytes(Unpooled.copiedBuffer((byte[][])((byte[][])triple.right)));
                packet.onMessage(packet, ctx);
                cache.invalidate((Object)message.id);
            }
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits()).writeLong(this.id.getLeastSignificantBits());
        buf.writeInt(this.packets);
        buf.writeInt(this.index);
        buf.writeInt(this.data.length);
        buf.writeBytes(this.data);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.packets = buf.readInt();
        this.index = buf.readInt();
        this.data = new byte[buf.readInt()];
        buf.readBytes(this.data);
    }

    static Iterable<? extends IMessage> split(MessageMultipartChange packet) {
        byte[] data;
        int bytesLeft;
        ByteBuf buf = Unpooled.buffer();
        packet.toBytes(buf);
        byte[] bytes = buf.array();
        if (bytesLeft < 32000) {
            return Collections.singleton(packet);
        }
        LinkedList<byte[]> packets = new LinkedList<byte[]>();
        for (bytesLeft = bytes.length; bytesLeft > 0; bytesLeft -= data.length) {
            data = new byte[bytesLeft < 32000 ? bytesLeft : Math.min(bytesLeft, 31000)];
            System.arraycopy(bytes, bytes.length - bytesLeft, data, 0, data.length);
            packets.add(data);
        }
        UUID id = UUID.randomUUID();
        int i = 0;
        HashSet<MessageSplit> set = new HashSet<MessageSplit>();
        for (byte[] data2 : packets) {
            set.add(new MessageSplit(id, packets.size(), i++, data2));
        }
        return set;
    }
}

