/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class PieceTrickEidosReversal
extends PieceTrick {
    SpellParam time;

    public PieceTrickEidosReversal(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.time = new ParamNumber("psi.spellparam.time", 0xD22A2A, false, true);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double timeVal = (Double)this.getParamEvaluation(this.time);
        if (timeVal == null || timeVal <= 0.0 || timeVal != (double)timeVal.intValue()) {
            throw new SpellCompilationException("psi.spellerror.nonpositiveinteger", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, (int)(timeVal * 11.0 + 20.0));
        meta.addStat(EnumSpellStat.COST, timeVal.intValue() * 40);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Double timeVal = (Double)this.getParamValue(context, this.time);
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(context.caster);
        if (!data.isReverting) {
            data.eidosReversionTime = timeVal.intValue() * 10;
            data.isReverting = true;
        }
        return null;
    }
}

