/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickDelay
extends PieceTrick {
    SpellParam time;

    public PieceTrickDelay(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.time = new ParamNumber("psi.spellparam.time", 2774482, false, true);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.COMPLEXITY, 1);
        Double timeVal = (Double)this.getParamEvaluation(this.time);
        if (timeVal == null || timeVal <= 0.0 || timeVal != (double)timeVal.intValue()) {
            throw new SpellCompilationException("psi.spellerror.nonpositiveinteger", this.x, this.y);
        }
        meta.addStat(EnumSpellStat.POTENCY, timeVal.intValue());
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Double timeVal = (Double)this.getParamValue(context, this.time);
        context.delay = timeVal.intValue();
        return null;
    }
}

