/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.psi.api.spell.CompiledSpell;
import vazkii.psi.api.spell.EnumPieceType;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellCompiler;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellPiece;

public final class SpellCompiler
implements ISpellCompiler {
    Spell spell;
    CompiledSpell compiled = null;
    String error = null;
    Pair<Integer, Integer> errorLocation = null;
    Stack<SpellPiece> tricks = new Stack();

    public SpellCompiler(Spell spell) {
        this.spell = spell;
        try {
            this.compile();
        }
        catch (SpellCompilationException e) {
            this.error = e.getMessage();
            this.errorLocation = e.location;
        }
    }

    public void compile() throws SpellCompilationException {
        if (this.spell == null) {
            throw new SpellCompilationException("psi.spellerror.nospell");
        }
        this.compiled = new CompiledSpell(this.spell);
        this.findTricks();
        while (!this.tricks.isEmpty()) {
            this.buildPiece(this.tricks.pop());
        }
        if (this.compiled.metadata.stats.get((Object)EnumSpellStat.COST) < 0 || this.compiled.metadata.stats.get((Object)EnumSpellStat.POTENCY) < 0) {
            throw new SpellCompilationException("psi.spellerror.statoverflow");
        }
        if (this.spell.name == null || this.spell.name.isEmpty()) {
            throw new SpellCompilationException("psi.spellerror.noname");
        }
    }

    public void buildPiece(SpellPiece piece) throws SpellCompilationException {
        this.buildPiece(piece, new ArrayList<SpellPiece>());
    }

    public void buildPiece(SpellPiece piece, List<SpellPiece> visited) throws SpellCompilationException {
        CompiledSpell.Action a;
        if (visited.contains(piece)) {
            throw new SpellCompilationException("psi.spellerror.loop", piece.x, piece.y);
        }
        if (this.compiled.actionMap.containsKey(piece)) {
            a = this.compiled.actionMap.get(piece);
            this.compiled.actions.remove(a);
            this.compiled.actions.add(a);
        } else {
            CompiledSpell compiledSpell = this.compiled;
            compiledSpell.getClass();
            a = compiledSpell.new CompiledSpell.Action(piece);
            this.compiled.actions.add(a);
            this.compiled.actionMap.put(piece, a);
            piece.addToMetadata(this.compiled.metadata);
        }
        visited.add(piece);
        ArrayList<SpellParam.Side> usedSides = new ArrayList<SpellParam.Side>();
        for (SpellParam param : piece.paramSides.keySet()) {
            SpellParam.Side side = piece.paramSides.get(param);
            if (!side.isEnabled()) {
                if (param.canDisable) continue;
                throw new SpellCompilationException("psi.spellerror.unsetparam", piece.x, piece.y);
            }
            if (usedSides.contains((Object)side)) {
                throw new SpellCompilationException("psi.spellerror.samesideparams", piece.x, piece.y);
            }
            usedSides.add(side);
            SpellPiece pieceAt = this.spell.grid.getPieceAtSideWithRedirections(piece.x, piece.y, side);
            if (pieceAt == null) {
                throw new SpellCompilationException("psi.spellerror.nullparam", piece.x, piece.y);
            }
            if (!param.canAccept(pieceAt)) {
                throw new SpellCompilationException("psi.spellerror.invalidparam", piece.x, piece.y);
            }
            this.buildPiece(pieceAt, new ArrayList<SpellPiece>(visited));
        }
    }

    public void findTricks() throws SpellCompilationException {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                SpellPiece piece = this.spell.grid.gridData[j][i];
                if (piece == null) continue;
                if (piece.getPieceType() == EnumPieceType.TRICK) {
                    this.tricks.add(piece);
                    continue;
                }
                if (piece.getPieceType() != EnumPieceType.MODIFIER) continue;
                piece.addToMetadata(this.compiled.metadata);
            }
        }
        if (this.tricks.isEmpty()) {
            throw new SpellCompilationException("psi.spellerror.notricks");
        }
    }

    @Override
    public CompiledSpell getCompiledSpell() {
        return this.compiled;
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public Pair<Integer, Integer> getErrorLocation() {
        return this.errorLocation;
    }

    @Override
    public boolean isErrored() {
        return this.error != null;
    }
}

