/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.internal.VanillaPacketDispatcher;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.common.block.tile.TileProgrammer;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.crafting.recipe.BulletToDriveRecipe;
import vazkii.psi.common.crafting.recipe.DriveDuplicateRecipe;
import vazkii.psi.common.item.base.IPsiItem;

public class ItemSpellDrive
extends ItemMod
implements IPsiItem {
    private static final String TAG_SPELL = "spell";

    public ItemSpellDrive() {
        super("spellDrive", new String[0]);
        this.func_77625_d(1);
        GameRegistry.addRecipe((IRecipe)new DriveDuplicateRecipe());
        GameRegistry.addRecipe((IRecipe)new BulletToDriveRecipe());
        RecipeSorter.register((String)"psi:driveDuplicate", DriveDuplicateRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        RecipeSorter.register((String)"psi:bulletToDrive", BulletToDriveRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    public boolean hasContainerItem(ItemStack stack) {
        return ItemSpellDrive.getSpell(stack) != null;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_SPELL, (boolean)false);
        String spellName = cmp.func_74779_i("spellName");
        if (spellName == null || spellName.isEmpty()) {
            return name;
        }
        return name + " (" + TextFormatting.GREEN + spellName + TextFormatting.RESET + ")";
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileProgrammer) {
            TileProgrammer programmer = (TileProgrammer)tile;
            Spell spell = ItemSpellDrive.getSpell(stack);
            if (spell == null && programmer.canCompile()) {
                ItemSpellDrive.setSpell(stack, programmer.spell);
                if (!worldIn.field_72995_K) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, PsiSoundHandler.bulletCreate, SoundCategory.PLAYERS, 0.5f, 1.0f);
                }
                return EnumActionResult.SUCCESS;
            }
            if (spell != null) {
                boolean enabled = programmer.isEnabled();
                if (enabled && !programmer.playerLock.isEmpty()) {
                    if (!programmer.playerLock.equals(playerIn.func_70005_c_())) {
                        if (!worldIn.field_72995_K) {
                            playerIn.func_146105_b(new TextComponentTranslation("psimisc.notYourProgrammer", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                        }
                        return EnumActionResult.SUCCESS;
                    }
                } else {
                    programmer.playerLock = playerIn.func_70005_c_();
                }
                programmer.spell = spell;
                programmer.onSpellChanged();
                if (!worldIn.field_72995_K) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, PsiSoundHandler.bulletCreate, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)programmer);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (ItemSpellDrive.getSpell(itemStackIn) != null && playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, PsiSoundHandler.compileError, SoundCategory.PLAYERS, 0.5f, 1.0f);
            } else {
                playerIn.func_184609_a(hand);
            }
            ItemSpellDrive.setSpell(itemStackIn, null);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
    }

    public static void setSpell(ItemStack stack, Spell spell) {
        NBTTagCompound cmp = new NBTTagCompound();
        if (spell != null) {
            spell.writeToNBT(cmp);
        }
        ItemNBTHelper.setCompound((ItemStack)stack, (String)TAG_SPELL, (NBTTagCompound)cmp);
    }

    public static Spell getSpell(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_SPELL, (boolean)false);
        return Spell.createFromNBT(cmp);
    }
}

