/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import com.google.common.base.Optional;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.spell.ISpellContainer;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.common.Psi;

public class EntitySpellCircle
extends Entity {
    public static final int CAST_TIMES = 20;
    public static final int CAST_DELAY = 5;
    public static final int LIVE_TIME = 110;
    private static final String TAG_COLORIZER = "colorizer";
    private static final String TAG_BULLET = "bullet";
    private static final String TAG_CASTER = "caster";
    private static final String TAG_TIME_ALIVE = "timeAlive";
    private static final String TAG_TIMES_CAST = "timesCast";
    private static final String TAG_LOOK_X = "savedLookX";
    private static final String TAG_LOOK_Y = "savedLookY";
    private static final String TAG_LOOK_Z = "savedLookZ";
    public static final DataParameter COLORIZER_DATA = EntityDataManager.func_187226_a(EntitySpellCircle.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter BULLET_DATA = EntityDataManager.func_187226_a(EntitySpellCircle.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter CASTER_NAME = EntityDataManager.func_187226_a(EntitySpellCircle.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter TIME_ALIVE = EntityDataManager.func_187226_a(EntitySpellCircle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter TIMES_CAST = EntityDataManager.func_187226_a(EntitySpellCircle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter LOOK_X = EntityDataManager.func_187226_a(EntitySpellCircle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter LOOK_Y = EntityDataManager.func_187226_a(EntitySpellCircle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter LOOK_Z = EntityDataManager.func_187226_a(EntitySpellCircle.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntitySpellCircle(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 0.0f);
    }

    public EntitySpellCircle setInfo(EntityPlayer player, ItemStack colorizer, ItemStack bullet) {
        this.field_70180_af.func_187227_b(COLORIZER_DATA, (Object)Optional.fromNullable((Object)colorizer));
        this.field_70180_af.func_187227_b(BULLET_DATA, (Object)Optional.of((Object)bullet));
        this.field_70180_af.func_187227_b(CASTER_NAME, (Object)player.func_70005_c_());
        Vec3d lookVec = player.func_70676_i(1.0f);
        this.field_70180_af.func_187227_b(LOOK_X, (Object)Float.valueOf((float)lookVec.field_72450_a));
        this.field_70180_af.func_187227_b(LOOK_Y, (Object)Float.valueOf((float)lookVec.field_72448_b));
        this.field_70180_af.func_187227_b(LOOK_Z, (Object)Float.valueOf((float)lookVec.field_72449_c));
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLORIZER_DATA, (Object)Optional.of((Object)new ItemStack(Blocks.field_150348_b)));
        this.field_70180_af.func_187214_a(BULLET_DATA, (Object)Optional.of((Object)new ItemStack(Blocks.field_150348_b)));
        this.field_70180_af.func_187214_a(CASTER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(TIME_ALIVE, (Object)0);
        this.field_70180_af.func_187214_a(TIMES_CAST, (Object)0);
        this.field_70180_af.func_187214_a(LOOK_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOOK_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOOK_Z, (Object)Float.valueOf(0.0f));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        NBTTagCompound colorizerCmp = new NBTTagCompound();
        ItemStack colorizer = (ItemStack)((Optional)this.field_70180_af.func_187225_a(COLORIZER_DATA)).orNull();
        if (colorizer != null) {
            colorizer.func_77955_b(colorizerCmp);
        }
        tagCompound.func_74782_a(TAG_COLORIZER, (NBTBase)colorizerCmp);
        NBTTagCompound bulletCmp = new NBTTagCompound();
        ItemStack bullet = (ItemStack)((Optional)this.field_70180_af.func_187225_a(BULLET_DATA)).orNull();
        if (bullet != null) {
            bullet.func_77955_b(bulletCmp);
        }
        tagCompound.func_74782_a(TAG_BULLET, (NBTBase)bulletCmp);
        tagCompound.func_74778_a(TAG_CASTER, (String)this.field_70180_af.func_187225_a(CASTER_NAME));
        tagCompound.func_74768_a(TAG_TIME_ALIVE, this.getTimeAlive());
        tagCompound.func_74768_a(TAG_TIMES_CAST, ((Integer)this.field_70180_af.func_187225_a(TIMES_CAST)).intValue());
        tagCompound.func_74776_a(TAG_LOOK_X, ((Float)this.field_70180_af.func_187225_a(LOOK_X)).floatValue());
        tagCompound.func_74776_a(TAG_LOOK_Y, ((Float)this.field_70180_af.func_187225_a(LOOK_Y)).floatValue());
        tagCompound.func_74776_a(TAG_LOOK_Z, ((Float)this.field_70180_af.func_187225_a(LOOK_Z)).floatValue());
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        NBTTagCompound colorizerCmp = tagCompound.func_74775_l(TAG_COLORIZER);
        ItemStack colorizer = ItemStack.func_77949_a((NBTTagCompound)colorizerCmp);
        this.field_70180_af.func_187227_b(COLORIZER_DATA, (Object)Optional.fromNullable((Object)colorizer));
        NBTTagCompound bulletCmp = tagCompound.func_74775_l(TAG_BULLET);
        ItemStack bullet = ItemStack.func_77949_a((NBTTagCompound)bulletCmp);
        this.field_70180_af.func_187227_b(BULLET_DATA, (Object)Optional.of((Object)bullet));
        this.field_70180_af.func_187227_b(CASTER_NAME, (Object)tagCompound.func_74779_i(TAG_CASTER));
        this.setTimeAlive(tagCompound.func_74762_e(TAG_TIME_ALIVE));
        this.field_70180_af.func_187227_b(TIMES_CAST, (Object)tagCompound.func_74762_e(TAG_TIMES_CAST));
        this.field_70180_af.func_187227_b(LOOK_X, (Object)Float.valueOf(tagCompound.func_74760_g(TAG_LOOK_X)));
        this.field_70180_af.func_187227_b(LOOK_Y, (Object)Float.valueOf(tagCompound.func_74760_g(TAG_LOOK_Y)));
        this.field_70180_af.func_187227_b(LOOK_Z, (Object)Float.valueOf(tagCompound.func_74760_g(TAG_LOOK_Z)));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int timeAlive = this.getTimeAlive();
        if (timeAlive > 110) {
            this.func_70106_y();
        }
        this.setTimeAlive(timeAlive + 1);
        int times = (Integer)this.field_70180_af.func_187225_a(TIMES_CAST);
        if (timeAlive > 5 && timeAlive % 5 == 0 && times < 20) {
            ItemStack spellContainer;
            SpellContext context = null;
            EntityLivingBase thrower = this.getCaster();
            if (thrower != null && thrower instanceof EntityPlayer && (spellContainer = (ItemStack)((Optional)this.field_70180_af.func_187225_a(BULLET_DATA)).orNull()) != null && spellContainer.func_77973_b() instanceof ISpellContainer) {
                this.field_70180_af.func_187227_b(TIMES_CAST, (Object)(times + 1));
                Spell spell = ((ISpellContainer)spellContainer.func_77973_b()).getSpell(spellContainer);
                if (spell != null) {
                    context = new SpellContext().setPlayer((EntityPlayer)thrower).setFocalPoint(this).setSpell(spell).setLoopcastIndex(times);
                }
            }
            if (context != null) {
                context.cspell.safeExecute(context);
            }
        }
        int colorVal = 1295871;
        ItemStack colorizer = (ItemStack)((Optional)this.field_70180_af.func_187225_a(COLORIZER_DATA)).orNull();
        if (colorizer != null && colorizer.func_77973_b() instanceof ICADColorizer) {
            colorVal = Psi.proxy.getColorizerColor(colorizer).getRGB();
        }
        Color color = new Color(colorVal);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        for (int i = 0; i < 5; ++i) {
            double x = this.field_70165_t + (Math.random() - 0.5) * (double)this.field_70130_N;
            double y = this.field_70163_u - this.func_70033_W();
            double z = this.field_70161_v + (Math.random() - 0.5) * (double)this.field_70130_N;
            float grav = -0.15f - (float)Math.random() * 0.03f;
            Psi.proxy.sparkleFX(this.field_70170_p, x, y, z, r, g, b, grav, 0.25f, 15);
        }
    }

    public Vec3d func_70676_i(float f) {
        float x = ((Float)this.field_70180_af.func_187225_a(LOOK_X)).floatValue();
        float y = ((Float)this.field_70180_af.func_187225_a(LOOK_Y)).floatValue();
        float z = ((Float)this.field_70180_af.func_187225_a(LOOK_Z)).floatValue();
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public int getTimeAlive() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_ALIVE);
    }

    public void setTimeAlive(int i) {
        this.field_70180_af.func_187227_b(TIME_ALIVE, (Object)i);
    }

    public EntityLivingBase getCaster() {
        String name = (String)this.field_70180_af.func_187225_a(CASTER_NAME);
        EntityPlayer player = this.field_70170_p.func_72924_a(name);
        return player;
    }
}

