/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.handler;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    public static boolean usePersistentData;
    public static boolean useShaders;
    public static boolean psiBarOnRight;
    public static boolean contextSensitiveBar;
    public static boolean useVanillaParticleLimiter;
    public static int maxPsiBarScale;
    public static boolean versionCheckEnabled;
    public static int spellCacheSize;
    public static int cadHarvestLevel;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.load();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void load() {
        String desc = "Controls whether Psi is allowed to save and load Persistent Data outside your instance. This data is stored where .minecraft would be by default and is independent of instance, world or modpack, and allows you to instantly get back to the highest level you were at previously in your last world.";
        usePersistentData = ConfigHandler.loadPropBool("Use Persistent Data", desc, usePersistentData);
        desc = "Controls whether Psi's shaders are used. If you're using the GLSL Shaders mod and are having graphical troubles with Psi stuff, you may want to turn this off.";
        useShaders = ConfigHandler.loadPropBool("Use Shaders", desc, useShaders);
        desc = "Controls whether the Psi Bar should be rendered on the right of the screen or not.";
        psiBarOnRight = ConfigHandler.loadPropBool("Psi Bar on the Right", desc, psiBarOnRight);
        desc = "Controls whether the Psi Bar should be hidden if it's full and the player is holding an item that uses Psi.";
        contextSensitiveBar = ConfigHandler.loadPropBool("Context Sensitive Bar", desc, contextSensitiveBar);
        desc = "Controls whether the \"Particles\" setting in the Vanilla options menu is accounted for when creating particles. Set to false to always have particles even if you change the Vanilla setting.";
        useVanillaParticleLimiter = ConfigHandler.loadPropBool("Use Vanilla Particle Limiter", desc, useVanillaParticleLimiter);
        desc = "The maximum scale your Psi bar can be. This prevents it from being too large on a bigger GUI scale. This is maximum amount of \"on screen pixels\" each actual pixel can take.";
        maxPsiBarScale = ConfigHandler.loadPropInt("Maximum Psi Bar Scale", desc, maxPsiBarScale);
        desc = "Set this to false to disable checking and alerting when new Botania versions come out. (keywords for noobs: update notification message)";
        versionCheckEnabled = ConfigHandler.loadPropBool("Version Checking", desc, versionCheckEnabled);
        desc = "How many compiled spells should be kept in a cache. Probably best not to mess with it if you don't know what you're doing.";
        spellCacheSize = ConfigHandler.loadPropInt("Spell Cache Size", desc, spellCacheSize);
        desc = "The harvest level of a CAD for the purposes of block breaking spells. 3 is diamond level. Defaults to 2 (iron level)";
        cadHarvestLevel = ConfigHandler.loadPropInt("CAD Harvest Level", desc, cadHarvestLevel);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadPropInt(String propName, String desc, int default_) {
        Property prop = config.get("general", propName, default_);
        prop.setComment(desc);
        return prop.getInt(default_);
    }

    public static double loadPropDouble(String propName, String desc, double default_) {
        Property prop = config.get("general", propName, default_);
        prop.setComment(desc);
        return prop.getDouble(default_);
    }

    public static boolean loadPropBool(String propName, String desc, boolean default_) {
        Property prop = config.get("general", propName, default_);
        prop.setComment(desc);
        return prop.getBoolean(default_);
    }

    static {
        usePersistentData = true;
        useShaders = true;
        psiBarOnRight = true;
        contextSensitiveBar = true;
        useVanillaParticleLimiter = true;
        maxPsiBarScale = 3;
        versionCheckEnabled = true;
        spellCacheSize = 100;
        cadHarvestLevel = 2;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("Psi")) {
                ConfigHandler.load();
            }
        }
    }
}

