/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.internal.IPlayerData;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellGrid;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellPiece;
import vazkii.psi.api.spell.SpellRuntimeException;

public class CompiledSpell {
    public Spell sourceSpell;
    public SpellMetadata metadata = new SpellMetadata();
    public Stack<Action> actions = new Stack();
    public Map<SpellPiece, Action> actionMap = new HashMap<SpellPiece, Action>();
    public Action currentAction;
    public boolean[][] spotsEvaluated;

    public CompiledSpell(Spell source) {
        this.sourceSpell = source;
        this.metadata.setStat(EnumSpellStat.BANDWIDTH, source.grid.getSize());
        this.spotsEvaluated = new boolean[9][9];
    }

    public boolean execute(SpellContext context) throws SpellRuntimeException {
        IPlayerData data = PsiAPI.internalHandler.getDataForPlayer(context.caster);
        while (!context.actions.isEmpty()) {
            Action a;
            this.currentAction = a = context.actions.pop();
            a.execute(data, context);
            this.currentAction = null;
            if (context.stopped) {
                return false;
            }
            if (context.delay <= 0) continue;
            return true;
        }
        return false;
    }

    public void safeExecute(SpellContext context) {
        block4: {
            try {
                if (context.actions == null) {
                    context.actions = (Stack)this.actions.clone();
                }
                if (context.cspell.execute(context)) {
                    PsiAPI.internalHandler.delayContext(context);
                }
            }
            catch (SpellRuntimeException e) {
                if (context.caster.field_70170_p.field_72995_K || context.shouldSuppressErrors()) break block4;
                context.caster.func_146105_b(new TextComponentTranslation(e.getMessage(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                int x = context.cspell.currentAction.piece.x + 1;
                int y = context.cspell.currentAction.piece.y + 1;
                context.caster.func_146105_b(new TextComponentTranslation("psi.spellerror.position", new Object[]{x, y}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
    }

    public boolean hasEvaluated(int x, int y) {
        if (!SpellGrid.exists(x, y)) {
            return false;
        }
        return this.spotsEvaluated[x][y];
    }

    public class Action {
        public final SpellPiece piece;

        public Action(SpellPiece piece) {
            this.piece = piece;
        }

        public void execute(IPlayerData data, SpellContext context) throws SpellRuntimeException {
            data.markPieceExecuted(this.piece);
            Object o = this.piece.execute(context);
            Class<?> eval = this.piece.getEvaluationType();
            if (eval != null && eval != SpellPiece.Null.class) {
                context.evaluatedObjects[this.piece.x][this.piece.y] = o;
            }
        }
    }
}

