/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.api.ITileReceiver;
import codechicken.wirelessredstone.init.ModItems;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.part.TransceiverPart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class ReceiverPart
extends TransceiverPart
implements ITileReceiver {
    public static Cuboid6[] extensionBB = new Cuboid6[24];

    @Override
    public ItemStack getItem() {
        return new ItemStack(ModItems.itemWireless, 1, 1);
    }

    @Override
    public int strongPowerLevel(int side) {
        return side == Rotation.rotateSide((int)this.side(), (int)this.rotation()) && this.active() ? 15 : 0;
    }

    @Override
    public void setActive(boolean on) {
        super.setActive(on);
        this.updateChange();
        this.tile().notifyNeighborChange(Rotation.rotateSide((int)this.side(), (int)this.rotation()));
    }

    @Override
    public void jamTile() {
        super.jamTile();
        this.changeSpinState(true);
        this.setActive(false);
    }

    @Override
    public void unjamTile() {
        super.unjamTile();
        this.changeSpinState(false);
        this.addToEther();
    }

    public void changeSpinState(boolean jam) {
        if (!jam && this.spinoffset < 0) {
            int time = (int)(this.world().func_82737_E() % 100000L);
            this.spinoffset = time + this.spinoffset;
        } else if (jam && this.spinoffset >= 0) {
            int time = (int)((this.world().func_82737_E() - (long)this.spinoffset) % 100000L);
            this.spinoffset = -time;
        }
    }

    @Override
    public Vector3 getFocalPoint() {
        return new Vector3(0.0755, 0.255, 0.0).apply(this.rotationT());
    }

    @Override
    public Vector3 getPearlPos() {
        return new Vector3(0.0, this.getFloating() * 0.02, 0.0).apply(this.getPearlRotation()).add(0.5, 0.755, 0.545);
    }

    @Override
    public Transformation getPearlRotation() {
        return new Rotation(0.7854, 1.0, 0.0, 0.0);
    }

    @Override
    public double getPearlScale() {
        return 0.04;
    }

    @Override
    public double getPearlSpin() {
        if (this.spinoffset < 0) {
            return RedstoneEther.getRotation(-this.spinoffset, this.currentfreq);
        }
        return RedstoneEther.getRotation(ClientUtils.getRenderTime() - (double)this.spinoffset, this.currentfreq);
    }

    @Override
    public float getPearlLight() {
        float light = this.world().func_175724_o(this.pos());
        light = (this.deadmap & 1) == 1 || this.deadmap == 0 && (this.disabled() || !this.active() || this.currentfreq == 0) ? (light + 1.0f) * 0.25f : (light + 1.0f) * 0.5f;
        return light;
    }

    @Override
    public void setFreq(int newfreq) {
        super.setFreq(newfreq);
        if (newfreq == 0) {
            this.setActive(false);
        }
    }

    @Override
    public void addToEther() {
        RedstoneEther.server().addReceiver(this.world(), this.x(), this.y(), this.z(), this.currentfreq);
    }

    @Override
    public void removeFromEther() {
        RedstoneEther.server().remReceiver(this.world(), this.x(), this.y(), this.z(), this.currentfreq);
    }

    @Override
    public String getGuiName() {
        return I18n.func_74838_a((String)"item.wrcbe:wireless_part|1.name");
    }

    public String getType() {
        return "wrcbe-recv";
    }

    @Override
    public void read(MCDataInput packet) {
        super.read(packet);
        this.changeSpinState(this.disabled());
    }

    @Override
    public Cuboid6 getExtensionBB() {
        return extensionBB[this.shape()];
    }

    @Override
    public int modelId() {
        return 1;
    }

    @Override
    public double m1() {
        return 0.0;
    }

    @Override
    public double m2(double d) {
        return 0.0;
    }

    @Override
    public void m3(double d) {
    }

    static {
        Cuboid6 base = new Cuboid6(0.1875, 0.125, 0.125, 0.8125, 0.8125, 0.625);
        for (int s = 0; s < 6; ++s) {
            for (int r = 0; r < 4; ++r) {
                ReceiverPart.extensionBB[s << 2 | r] = base.copy().apply(Rotation.sideOrientation((int)s, (int)r).at(Vector3.center));
            }
        }
    }
}

