/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.command;

import codechicken.core.commands.CoreCommand;
import codechicken.lib.util.ServerUtils;
import codechicken.wirelessredstone.command.FreqParam;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherServer;
import java.util.Arrays;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ParamJam
extends FreqParam {
    @Override
    public void printHelp(ICommandSender listener) {
        CoreCommand.chatT((ICommandSender)listener, (String)"wrcbe.param.jam.usage", (Object[])new Object[0]);
        CoreCommand.chatT((ICommandSender)listener, (String)"wrcbe.param.jam.usage1", (Object[])new Object[0]);
        CoreCommand.chatT((ICommandSender)listener, (String)("wrcbe.param.jam.usage" + (rand.nextInt(5) + 2)), (Object[])new Object[]{"jam"});
    }

    @Override
    public String getName() {
        return "jam";
    }

    @Override
    public void handleCommand(String playername, String[] args, ICommandSender listener) {
        ParamJam.jamOpenCommand(playername, Arrays.copyOfRange(args, 1, args.length), listener, true);
    }

    public static void jamOpenCommand(String playername, String[] args, ICommandSender listener, boolean jam) {
        int endfreq;
        int startfreq;
        String jamPlayer;
        RedstoneEtherServer ether = RedstoneEther.server();
        if (args.length == 0) {
            CoreCommand.chatT((ICommandSender)listener, (String)"wrcbe.param.invalidno", (Object[])new Object[0]);
            return;
        }
        if (args.length == 1 && ServerUtils.getPlayer((String)playername) == null) {
            CoreCommand.chatT((ICommandSender)listener, (String)"wrcbe.param.jam.noplayer", (Object[])new Object[0]);
            return;
        }
        String range = args[args.length - 1];
        String string = jamPlayer = args.length == 1 ? playername : args[0];
        if (range.equals("all")) {
            startfreq = 1;
            endfreq = 5000;
        } else if (range.equals("default")) {
            startfreq = ether.getLastSharedFrequency() + 1;
            endfreq = 5000;
        } else {
            int[] freqrange = RedstoneEther.parseFrequencyRange(range);
            startfreq = freqrange[0];
            endfreq = freqrange[1];
        }
        if (startfreq < 1 || endfreq > 5000 || endfreq < startfreq) {
            CoreCommand.chatT((ICommandSender)listener, (String)"wrcbe.param.invalidfreqrange", (Object[])new Object[0]);
            return;
        }
        ether.setFrequencyRangeCommand(jamPlayer, startfreq, endfreq, jam);
        int publicend = ether.getLastPublicFrequency();
        EntityPlayerMP player = ServerUtils.getPlayer((String)jamPlayer);
        String paramName = jam ? "jam" : "open";
        Style playerStyle = new Style().func_150238_a(TextFormatting.YELLOW);
        if (startfreq == endfreq) {
            if (startfreq <= publicend) {
                CoreCommand.chatT((ICommandSender)listener, (String)"wrcbe.param.jam.errpublic", (Object[])new Object[0]);
                return;
            }
            CoreCommand.chatOpsT((String)("wrcbe.param." + paramName + ".opjammed"), (Object[])new Object[]{playername, jamPlayer, startfreq});
            if (player != null) {
                player.func_145747_a(new TextComponentTranslation("wrcbe.param." + paramName + ".jammed", new Object[]{startfreq}).func_150255_a(playerStyle));
            }
        } else {
            if (startfreq <= publicend && endfreq <= publicend) {
                CoreCommand.chatT((ICommandSender)listener, (String)"wrcbe.param.jam.errpublic", (Object[])new Object[0]);
                return;
            }
            if (startfreq <= publicend) {
                startfreq = publicend + 1;
            }
            CoreCommand.chatOpsT((String)("wrcbe.param." + paramName + ".opjammed2"), (Object[])new Object[]{playername, jamPlayer, startfreq + "-" + endfreq});
            if (player != null) {
                player.func_146105_b(new TextComponentTranslation("wrcbe.param." + paramName + ".jammed2", new Object[]{startfreq + "-" + endfreq}).func_150255_a(playerStyle));
            }
        }
    }
}

