/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics.network;

import io.netty.buffer.ByteBuf;
import knightminer.ceramics.network.PacketBase;
import knightminer.ceramics.tileentity.TileBarrel;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BarrelCapacityChangedPacket
extends PacketBase {
    public BlockPos pos;
    public int capacity;

    public BarrelCapacityChangedPacket() {
    }

    public BarrelCapacityChangedPacket(BlockPos pos, int capacity) {
        this.pos = pos;
        this.capacity = capacity;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        this.capacity = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        buf.writeInt(this.capacity);
    }

    public static class BarrelCapacityChangedHandler
    implements IMessageHandler<BarrelCapacityChangedPacket, IMessage> {
        public IMessage onMessage(final BarrelCapacityChangedPacket message, MessageContext ctx) {
            PacketBase.getMainThread(ctx).func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
                    if (te instanceof TileBarrel) {
                        ((TileBarrel)te).updateCapacityTo(message.capacity);
                    }
                }
            });
            return null;
        }
    }
}

