/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.io.FileHandler;
import journeymap.client.model.SplashInfo;
import journeymap.client.model.SplashPerson;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.dialog.OptionsManager;
import journeymap.common.Journeymap;
import journeymap.common.properties.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class Splash
extends JmUI {
    protected TextureImpl patreonLogo = TextureCache.getTexture(TextureCache.Patreon);
    Button buttonClose;
    Button buttonOptions;
    Button buttonDonate;
    ButtonList peopleButtons;
    ButtonList devButtons;
    ButtonList bottomButtons;
    ButtonList infoButtons;
    private List<SplashPerson> people = Arrays.asList(new SplashPerson("AlexDurrani", "Sikandar Durrani", "jm.common.splash_patreon"), new SplashPerson("Davkas", "Davkas", "jm.common.splash_patreon"), new SplashPerson("_cache_", "Shaila Gray", "jm.common.splash_patreon"));
    private List<SplashPerson> devs = Arrays.asList(new SplashPerson("mysticdrew", "mysticdrew", "jm.common.splash_developer"), new SplashPerson("techbrew", "techbrew", "jm.common.splash_developer"));
    private SplashInfo info;
    private TextureImpl brickTex = TextureCache.getTexture(TextureCache.Brick);

    public Splash(JmUI returnDisplay) {
        super(Constants.getString("jm.common.splash_title", Journeymap.JM_VERSION), returnDisplay);
    }

    @Override
    public void func_73866_w_() {
        Button button;
        Journeymap.getClient().getCoreProperties().splashViewed.set(Journeymap.JM_VERSION.toString());
        if (this.info == null) {
            String bday;
            this.info = FileHandler.getMessageModel(SplashInfo.class, "splash");
            if (this.info == null) {
                this.info = new SplashInfo();
            }
            if ((bday = Constants.birthdayMessage()) != null) {
                this.info.lines.add(0, new SplashInfo.Line(bday, "dialog.FullscreenActions#tweet#" + bday));
                this.devs = new ArrayList<SplashPerson>(this.devs);
                this.devs.add(new SplashPerson.Fake("", "", TextureCache.getTexture(TextureCache.ColorPicker2)));
            }
        }
        this.field_146292_n.clear();
        FontRenderer fr = this.getFontRenderer();
        int minWidth = 0;
        this.peopleButtons = new ButtonList();
        this.devButtons = new ButtonList();
        for (SplashPerson person : this.people) {
            button = new Button(person.name);
            this.peopleButtons.add(button);
            person.setButton(button);
            minWidth = Math.max(minWidth, person.getWidth(fr));
        }
        this.peopleButtons.setWidths(minWidth);
        this.infoButtons = new ButtonList();
        for (SplashInfo.Line line : this.info.lines) {
            button = new SplashInfoButton(line);
            button.setDrawBackground(false);
            button.setDefaultStyle(false);
            button.setDrawFrame(false);
            button.setHeight(fr.field_78288_b + 5);
            if (line.hasAction()) {
                button.setTooltip(Constants.getString("jm.common.splash_action"));
            }
            this.infoButtons.add(button);
        }
        this.infoButtons.equalizeWidths(fr);
        this.field_146292_n.addAll(this.infoButtons);
        this.buttonDonate = new Button("");
        this.buttonDonate.setDefaultStyle(false);
        this.buttonDonate.setDrawBackground(false);
        this.buttonDonate.setDrawFrame(false);
        this.buttonDonate.setTooltip(Constants.getString("jm.webmap.donate_text"));
        this.buttonClose = new Button(Constants.getString("jm.common.close"));
        this.buttonOptions = new Button(Constants.getString("jm.common.options_button"));
        this.bottomButtons = new ButtonList(this.buttonOptions, this.buttonDonate);
        if (this.field_146297_k.field_71441_e != null) {
            this.bottomButtons.add(this.buttonClose);
        }
        this.bottomButtons.equalizeWidths(this.getFontRenderer());
        this.bottomButtons.setWidths(Math.max(100, this.buttonOptions.getWidth()));
        this.buttonDonate.func_175211_a(50);
        this.field_146292_n.addAll(this.bottomButtons);
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        int hgap = 4;
        int vgap = 4;
        int bx = this.field_146294_l / 2;
        int by = 45;
        FontRenderer fr = this.getFontRenderer();
        int lineHeight = (int)((double)fr.field_78288_b * 1.4);
        int estimatedInfoHeight = 60 + (fr.field_78288_b + 5) * this.infoButtons.size();
        ((Object)((Object)this)).getClass();
        by = (this.field_146295_m + 35 - estimatedInfoHeight) / 2;
        int estimatedWallHeight = 90;
        int gap = 0;
        ((Object)((Object)this)).getClass();
        if (estimatedInfoHeight + estimatedWallHeight + 25 < this.field_146295_m - 35) {
            ((Object)((Object)this)).getClass();
            int empty = this.field_146295_m + 35 - estimatedInfoHeight - estimatedWallHeight;
            by = Math.max(45, empty / 3);
            gap = by / 4;
        }
        if (!this.devButtons.isEmpty()) {
            int temp = by;
            for (SplashPerson dev : this.devs) {
                temp = this.drawPerson(temp, lineHeight, dev);
                dev.avoid(this.devs);
                dev.adjustVector(this.field_146294_l, this.field_146295_m);
            }
        }
        if (!this.infoButtons.isEmpty()) {
            int topY = by;
            by = (int)((double)by + (double)lineHeight * 1.5);
            this.infoButtons.layoutCenteredVertical(bx - ((Button)this.infoButtons.get(0)).getWidth() / 2, by + this.infoButtons.getHeight(0) / 2, true, 0);
            int listX = this.infoButtons.getLeftX() - 10;
            int listY = topY - 5;
            int listWidth = this.infoButtons.getRightX() + 10 - listX;
            int listHeight = this.infoButtons.getBottomY() + 5 - listY;
            DrawUtil.drawGradientRect(listX - 1, listY - 1, listWidth + 2, listHeight + 2, 0xC0C0C0, 0.8f, 0xC0C0C0, 0.8f);
            DrawUtil.drawGradientRect(listX, listY, listWidth, listHeight, 0x404040, 1.0f, 0, 1.0f);
            DrawUtil.drawLabel(Constants.getString("jm.common.splash_whatisnew"), bx, topY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 65535, 1.0f, 1.0, true);
            by = listY + listHeight + 10;
        }
        if ((by += gap) + estimatedWallHeight < this.field_146295_m - 25) {
            int titleY = by;
            int listY = (by += lineHeight * 2) - 30;
            int listHeight = 100;
            this.peopleButtons.layoutCenteredHorizontal(bx, by, true, 10);
            int listX = this.peopleButtons.getLeftX() - 10;
            int listWidth = this.peopleButtons.getRightX() + 10 - listX;
            DrawUtil.drawGradientRect(listX - 1, listY - 1, listWidth + 2, listHeight + 2, 0xC0C0C0, 0.8f, 0xC0C0C0, 0.8f);
            this.brickTex.bindTexture();
            GlStateManager.func_179144_i((int)this.brickTex.func_110552_b());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            DrawUtil.drawBoundTexture(0.0, 0.0, listX, listY, 0.0, 8.0, 2.0, listX + listWidth, listY + listHeight);
            DrawUtil.drawLabel(Constants.getString("jm.common.splash_walloffame"), bx, titleY, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, Color.cyan.getRGB(), 1.0f, 1.0, true);
            if (this.devButtons.isEmpty()) {
                for (SplashPerson dev : this.devs) {
                    Button button = new Button(dev.name);
                    this.devButtons.add(button);
                    dev.setButton(button);
                }
                this.devButtons.equalizeWidths(fr);
                this.devButtons.layoutCenteredHorizontal(bx, by, true, 10);
            }
            for (SplashPerson person : this.people) {
                by = this.drawPerson(by, lineHeight, person);
            }
        }
        bx = this.field_146294_l / 2;
        by = this.field_146295_m - 25;
        this.bottomButtons.layoutCenteredHorizontal(bx, by, true, 4);
        DrawUtil.drawImage(this.patreonLogo, this.buttonDonate.getCenterX() - 8, this.buttonDonate.getY() + 2, false, 0.5f, 0.0);
    }

    protected int drawPerson(int by, int lineHeight, SplashPerson person) {
        float scale = 1.0f;
        Button button = person.getButton();
        int imgSize = (int)((float)person.getSkin().getWidth() * scale);
        int imgY = button.getY() - 2;
        int imgX = button.getCenterX() - imgSize / 2;
        GlStateManager.func_179141_d();
        if (!(person instanceof SplashPerson.Fake)) {
            DrawUtil.drawGradientRect(imgX - 1, imgY - 1, imgSize + 2, imgSize + 2, 0, 0.4f, 0, 0.8f);
            DrawUtil.drawImage(person.getSkin(), 1.0f, imgX, imgY, false, scale, 0.0);
        } else {
            float size = Math.min((float)person.getSkin().getWidth() * scale, 24.0f * scale);
            DrawUtil.drawQuad(person.getSkin(), 0xFFFFFF, 1.0f, imgX, imgY, size, size, false, 0.0);
        }
        by = imgY + imgSize + 4;
        String name = person.name.trim();
        String name2 = null;
        boolean twoLineName = name.contains(" ");
        if (twoLineName) {
            String[] parts = person.name.split(" ");
            name = parts[0];
            name2 = parts[1];
        }
        DrawUtil.drawLabel(name, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, scale, true);
        by += lineHeight;
        if (name2 != null) {
            DrawUtil.drawLabel(name2, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 0xFFFFFF, 1.0f, scale, true);
            by += lineHeight;
        }
        DrawUtil.drawLabel(person.title, button.getCenterX(), by, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, 0, 0.0f, 65280, 1.0f, scale, true);
        return by += lineHeight;
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.buttonClose) {
            this.closeAndReturn();
        }
        if (guibutton == this.buttonDonate) {
            FullscreenActions.launchPatreon();
        }
        if (guibutton == this.buttonOptions) {
            if (this.returnDisplay != null && this.returnDisplay instanceof OptionsManager) {
                this.closeAndReturn();
            } else {
                UIManager.INSTANCE.openOptionsManager(this, new Category[0]);
            }
        }
    }

    @Override
    protected void func_73869_a(char c, int i) {
        switch (i) {
            case 1: {
                this.closeAndReturn();
            }
        }
    }

    class SplashInfoButton
    extends Button {
        final SplashInfo.Line infoLine;

        public SplashInfoButton(SplashInfo.Line infoLine) {
            super(infoLine.label);
            this.infoLine = infoLine;
        }

        @Override
        public boolean mouseOver(int mouseX, int mouseY) {
            return super.mouseOver(mouseX, mouseY);
        }

        @Override
        public boolean func_146116_c(Minecraft minecraft, int i, int j) {
            boolean pressed = super.func_146116_c(minecraft, i, j);
            if (pressed) {
                this.infoLine.invokeAction(Splash.this);
            }
            return pressed;
        }
    }
}

