/*
 * Decompiled with CFR 0.152.
 */
package tehnut.launchgui.gui.javafx;

import java.net.URI;
import java.util.ArrayList;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import net.minecraft.client.resources.I18n;
import tehnut.launchgui.ConfigHandler;
import tehnut.launchgui.utils.LogHelper;
import tehnut.launchgui.utils.Utils;

public class UpdateWindow
extends Application {
    private Stage window;

    public static void initWindow() {
        UpdateWindow.launch((String[])new String[0]);
    }

    public void start(Stage primaryStage) {
        this.window = primaryStage;
        primaryStage.setTitle(I18n.func_135052_a((String)"gui.launchgui.update.title", (Object[])new Object[]{ConfigHandler.modpackName}));
        primaryStage.setWidth(700.0);
        primaryStage.setHeight(500.0);
        primaryStage.setAlwaysOnTop(true);
        primaryStage.setResizable(false);
        BorderPane border = new BorderPane();
        border.setPadding(new Insets(25.0, 25.0, 25.0, 25.0));
        VBox titleBox = new VBox(new Node[]{this.getTitle(), new Separator()});
        titleBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        titleBox.setSpacing(10.0);
        border.setTop((Node)titleBox);
        VBox bodyBox = new VBox(new Node[]{new VBox(this.getBodyText())});
        bodyBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        bodyBox.setSpacing(10.0);
        border.setCenter((Node)bodyBox);
        HBox buttonBox = new HBox(this.getButtons());
        buttonBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        buttonBox.setSpacing(10.0);
        border.setBottom((Node)new VBox(new Node[]{new Separator(), buttonBox}));
        primaryStage.setScene(new Scene((Parent)border));
        primaryStage.show();
    }

    private Node[] getBodyText() {
        String[] toDraw;
        ArrayList<Label> nodes = new ArrayList<Label>();
        for (String draw : toDraw = Utils.replaceTextCodes(ConfigHandler.updateGuiLines).split("\n")) {
            String[] cutWrapped;
            String wrapped = draw.replaceAll("(.{55})", "$1\n");
            for (String cut : cutWrapped = wrapped.split("\n")) {
                Label label = new Label(cut);
                label.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
                nodes.add(label);
            }
        }
        return nodes.toArray(new Node[nodes.size()]);
    }

    private Node[] getButtons() {
        Button acknowledgeButton = new Button(ConfigHandler.continueButtonText);
        acknowledgeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                UpdateWindow.this.window.close();
            }
        });
        acknowledgeButton.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        Button informationButton = new Button(ConfigHandler.updateInformationButtonText);
        informationButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                try {
                    Utils.browse(new URI(ConfigHandler.updateInformationUrl));
                }
                catch (Exception e) {
                    LogHelper.error("Failed to load the page at " + ConfigHandler.updateInformationUrl + "!");
                    e.printStackTrace();
                }
            }
        });
        informationButton.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)20.0));
        return new Node[]{acknowledgeButton, informationButton};
    }

    private Node getTitle() {
        Label title = new Label(I18n.func_135052_a((String)"gui.launchgui.update.avail", (Object[])new Object[0]));
        title.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.NORMAL, (double)25.0));
        return title;
    }
}

