/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    public static Configuration config;
    public static boolean allItems;
    public static boolean invertHandShift;
    public static List<String> whitelistedItems;
    public static List<String> whitelistedNames;
    public static List<String> blacklistedMods;
    public static Map<String, String> aliases;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.load();
        MinecraftForge.EVENT_BUS.register((Object)new ChangeListener());
    }

    public static void load() {
        allItems = ConfigHandler.loadPropBool("Allow all items to be added", false);
        invertHandShift = ConfigHandler.loadPropBool("Morph in the offhand instead of mainhand", false);
        whitelistedItems = ConfigHandler.loadPropStringList("Whitelisted Items", "botania:twigWand", "appliedenergistics2:ToolNetworkTool");
        whitelistedNames = ConfigHandler.loadPropStringList("Whitelisted Names", "wrench", "screwdriver", "hammer", "rotator");
        blacklistedMods = ConfigHandler.loadPropStringList("Blacklisted Mods", "tconstruct", "intangible");
        aliases.clear();
        List<String> aliasesList = ConfigHandler.loadPropStringList("Mod Aliases", "botanicaladdons=botania", "ThermalDynamics=ThermalExpansion", "rftoolsdim=rftools");
        for (String s : aliasesList) {
            if (!s.matches(".+?=.+")) continue;
            String[] tokens = s.toLowerCase().split("=");
            aliases.put(tokens[0], tokens[1]);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static List<String> loadPropStringList(String propName, String ... default_) {
        Property prop = config.get("general", propName, default_);
        return Arrays.asList(prop.getStringList());
    }

    public static boolean loadPropBool(String propName, boolean default_) {
        Property prop = config.get("general", propName, default_);
        return prop.getBoolean(default_);
    }

    static {
        aliases = new HashMap<String, String>();
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.getModID().equals("Morphtool")) {
                ConfigHandler.load();
            }
        }
    }
}

