/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.rewrite;

import java.util.EnumSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.config.Configuration;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.config.PackDefaults;
import tonius.simplyjetpacks.setup.ModItems;

public enum Fluxpack implements IStringSerializable
{
    CREATIVE_FLUXPACK("fluxPackCreative", "fluxPackCreative", 6, EnumRarity.EPIC, false, true),
    FLUXPACK_EIO1("fluxPackEIO1", "fluxPackEIO1", 1, EnumRarity.COMMON),
    FLUXPACK_EIO2("fluxPackEIO2", "fluxPackEIO2", 2, EnumRarity.UNCOMMON),
    FLUXPACK_EIO3("fluxPackEIO3", "fluxPackEIO3", 3, EnumRarity.RARE),
    FLUXPACK_EIO2_ARMORED("fluxPackEIO2Armored", "fluxPackEIO2", 2, EnumRarity.UNCOMMON, true, true),
    FLUXPACK_EIO3_ARMORED("fluxPackEIO3Armored", "fluxPackEIO3", 3, EnumRarity.RARE, true, true);

    @Nonnull
    public final String baseName;
    @Nonnull
    public final String unlocalisedName;
    public final int tier;
    public int fuelCapacity;
    public int fuelPerTickIn;
    public int fuelPerTickOut;
    public int armorFuelPerHit;
    public int armorReduction;
    public int fuelUsage;
    public boolean usesFuel;
    public EnumRarity rarity;
    public PackModelType armorModel = PackModelType.FLAT;
    protected final PackDefaults defaults;
    public boolean isArmored;
    protected static final EnumSet<Fluxpack> ALL_FLUXPACKS;
    protected static final EnumSet<Fluxpack> SJ_FLUXPACKS;

    private Fluxpack(String baseName, String defaultConfigKey, int tier, EnumRarity rarity, boolean usesFuel) {
        this(baseName, defaultConfigKey, tier, rarity);
        this.usesFuel = usesFuel;
    }

    private Fluxpack(String baseName, String defaultConfigKey, int tier, EnumRarity rarity, boolean usesFuel, boolean isArmored) {
        this(baseName, defaultConfigKey, tier, rarity, usesFuel);
        this.isArmored = isArmored;
    }

    private Fluxpack(String baseName, String defaultConfigKey, int tier, EnumRarity rarity) {
        this.baseName = baseName;
        this.defaults = PackDefaults.get(defaultConfigKey);
        this.tier = tier;
        this.unlocalisedName = "item.simplyjetpacks." + baseName;
        this.usesFuel = true;
        this.rarity = rarity;
        this.setArmorModel(PackModelType.FLUX_PACK);
    }

    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    public int getFuelCapacity() {
        return this.fuelCapacity;
    }

    public int getTier() {
        return this.tier;
    }

    public int getFuelPerTickIn() {
        return this.fuelPerTickIn;
    }

    public int getFuelPerTickOut() {
        return this.fuelPerTickOut;
    }

    public int getArmorFuelPerHit() {
        return this.armorFuelPerHit;
    }

    public int getArmorReduction() {
        return this.armorReduction;
    }

    public int getFuelUsage() {
        return this.fuelUsage;
    }

    public String func_176610_l() {
        return this.baseName.toLowerCase(Locale.ENGLISH);
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public boolean getIsArmored() {
        return this.isArmored;
    }

    @Nonnull
    public ItemStack getStackFluxpack() {
        return this.getStackFluxpack(1);
    }

    @Nonnull
    public ItemStack getStackFluxpack(int size) {
        return new ItemStack((Item)ModItems.itemFluxPack, size, this.ordinal());
    }

    @Nonnull
    public static Fluxpack getTypeFromMeta(int meta) {
        return Fluxpack.values()[meta >= 0 && meta < Fluxpack.values().length ? meta : 0];
    }

    public static int getMetaFromType(Fluxpack value) {
        return value.ordinal();
    }

    public Fluxpack setArmorModel(PackModelType armorModel) {
        this.armorModel = armorModel;
        return this;
    }

    public static void loadAllConfigs(Configuration config) {
        if (ModItems.integrateEIO) {
            for (Fluxpack pack : ALL_FLUXPACKS) {
                pack.loadConfig(config);
            }
        } else {
            for (Fluxpack pack : SJ_FLUXPACKS) {
                pack.loadConfig(config);
            }
        }
    }

    public static void writeAllConfigsToNBT(NBTTagCompound tag) {
        if (ModItems.integrateEIO) {
            for (Fluxpack pack : ALL_FLUXPACKS) {
                NBTTagCompound packTag = new NBTTagCompound();
                pack.writeConfigToNBT(packTag);
                tag.func_74782_a(pack.defaults.section.id, (NBTBase)packTag);
            }
        } else {
            for (Fluxpack pack : SJ_FLUXPACKS) {
                NBTTagCompound packTag = new NBTTagCompound();
                pack.writeConfigToNBT(packTag);
                tag.func_74782_a(pack.defaults.section.id, (NBTBase)packTag);
            }
        }
    }

    public static void readAllConfigsFromNBT(NBTTagCompound tag) {
        if (ModItems.integrateEIO) {
            for (Fluxpack pack : ALL_FLUXPACKS) {
                NBTTagCompound packTag = tag.func_74775_l(pack.defaults.section.id);
                pack.readConfigFromNBT(packTag);
            }
        } else {
            for (Fluxpack pack : SJ_FLUXPACKS) {
                NBTTagCompound packTag = tag.func_74775_l(pack.defaults.section.id);
                pack.readConfigFromNBT(packTag);
            }
        }
    }

    protected void loadConfig(Configuration config) {
        if (this.defaults.fuelCapacity != null) {
            this.fuelCapacity = config.get(this.defaults.section.name, "Fuel Capacity", this.defaults.fuelCapacity.intValue(), "The maximum amount of fuel that this pack can hold.").setMinValue(1).getInt(this.defaults.fuelCapacity.intValue());
        }
        if (this.defaults.fuelUsage != null) {
            this.fuelUsage = config.get(this.defaults.section.name, "Fuel Usage", this.defaults.fuelUsage.intValue(), "The amount of fuel that this pack uses every tick when used.").setMinValue(0).getInt(this.defaults.fuelUsage.intValue());
        }
        if (this.defaults.fuelPerTickIn != null) {
            this.fuelPerTickIn = config.get(this.defaults.section.name, "Fuel Per Tick In", this.defaults.fuelPerTickIn.intValue(), "The amount of fuel that can be inserted into this pack per tick from external sources.").setMinValue(0).getInt(this.defaults.fuelPerTickIn.intValue());
        }
        if (this.defaults.fuelPerTickOut != null) {
            this.fuelPerTickOut = config.get(this.defaults.section.name, "Fuel Per Tick Out", this.defaults.fuelPerTickOut.intValue(), "The amount of fuel that can be extracted from this pack per tick by external sources. Also determines how quickly Flux Packs can charge other items.").setMinValue(0).getInt(this.defaults.fuelPerTickOut.intValue());
        }
        if (this.defaults.armorReduction != null) {
            this.armorReduction = config.get(this.defaults.section.name, "Armor Reduction", this.defaults.armorReduction.intValue(), "How well this pack can protect the user from damage, if armored. The higher the value, the stronger the armor will be.").setMinValue(0).setMaxValue(20).getInt(this.defaults.armorReduction.intValue());
        }
        if (this.defaults.armorFuelPerHit != null) {
            this.armorFuelPerHit = config.get(this.defaults.section.name, "Armor Fuel Per Hit", this.defaults.armorFuelPerHit.intValue(), "How much fuel is lost from this pack when the user is hit, if armored.").setMinValue(0).getInt(this.defaults.armorFuelPerHit.intValue());
        }
    }

    protected void writeConfigToNBT(NBTTagCompound tag) {
        if (this.defaults.fuelCapacity != null) {
            tag.func_74768_a("FuelCapacity", this.fuelCapacity);
        }
        if (this.defaults.fuelUsage != null) {
            tag.func_74768_a("FuelUsage", this.fuelUsage);
        }
        if (this.defaults.fuelPerTickIn != null) {
            tag.func_74768_a("FuelPerTickIn", this.fuelPerTickIn);
        }
        if (this.defaults.fuelPerTickOut != null) {
            tag.func_74768_a("FuelPerTickOut", this.fuelPerTickOut);
        }
        if (this.defaults.armorReduction != null) {
            tag.func_74768_a("ArmorReduction", this.armorReduction);
        }
    }

    protected void readConfigFromNBT(NBTTagCompound tag) {
        if (this.defaults.fuelCapacity != null) {
            this.fuelCapacity = tag.func_74762_e("FuelCapacity");
        }
        if (this.defaults.fuelUsage != null) {
            this.fuelUsage = tag.func_74762_e("FuelUsage");
        }
        if (this.defaults.fuelPerTickIn != null) {
            this.fuelPerTickIn = tag.func_74762_e("FuelPerTickIn");
        }
        if (this.defaults.fuelPerTickOut != null) {
            this.fuelPerTickOut = tag.func_74762_e("FuelPerTickOut");
        }
        if (this.defaults.armorReduction != null) {
            this.armorReduction = tag.func_74762_e("ArmorReduction");
        }
    }

    static {
        ALL_FLUXPACKS = EnumSet.allOf(Fluxpack.class);
        SJ_FLUXPACKS = EnumSet.of(CREATIVE_FLUXPACK);
    }
}

