/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.meta;

import cofh.api.energy.IEnergyContainerItem;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.config.PackDefaults;
import tonius.simplyjetpacks.integration.ModType;
import tonius.simplyjetpacks.item.ItemPack;
import tonius.simplyjetpacks.setup.FuelType;
import tonius.simplyjetpacks.setup.ModKey;
import tonius.simplyjetpacks.util.EquipmentSlotHelper;
import tonius.simplyjetpacks.util.NBTHelper;
import tonius.simplyjetpacks.util.SJStringHelper;

public class PackBase {
    protected static final Set<PackBase> ALL_PACKS = new LinkedHashSet<PackBase>();
    protected static final String TAG_ON = "PackOn";
    public final String registryName;
    public final String name;
    public final int tier;
    public final EnumRarity rarity;
    protected final PackDefaults defaults;
    public int fuelCapacity = 1;
    public int fuelUsage = 0;
    public int fuelPerTickIn = 0;
    public int fuelPerTickOut = 0;
    public int armorReduction = 0;
    public int armorFuelPerHit = 0;
    public int enchantability = 0;
    public FuelType fuelType = FuelType.ENERGY;
    public String fuelFluid = null;
    public PackModelType armorModel = PackModelType.FLAT;
    public boolean showInCreativeTab = true;
    public boolean showEmptyInCreativeTab = true;
    public boolean usesFuel = true;
    public boolean hasFuelIndicator = true;
    public boolean hasStateIndicators = true;
    public boolean isArmored = false;
    public boolean showArmored = true;
    public boolean showTier = true;
    public Integer platingMeta = null;
    public boolean isFluxBased = false;

    public PackBase(String name, int tier, EnumRarity rarity, String defaultConfigKey) {
        this.name = name;
        this.tier = tier;
        this.rarity = rarity;
        this.defaults = PackDefaults.get(defaultConfigKey);
        this.registryName = defaultConfigKey;
        if (this.defaults == null) {
            throw new IllegalArgumentException("No PackDefaults instance found for key " + defaultConfigKey);
        }
        ALL_PACKS.add(this);
    }

    public PackBase(int tier, EnumRarity rarity, String defaultConfigKey) {
        this("pack", tier, rarity, defaultConfigKey);
    }

    public static void loadAllConfigs(Configuration config) {
        for (PackBase pack : ALL_PACKS) {
            pack.loadConfig(config);
        }
    }

    public static void writeAllConfigsToNBT(NBTTagCompound tag) {
        for (PackBase pack : ALL_PACKS) {
            NBTTagCompound packTag = new NBTTagCompound();
            pack.writeConfigToNBT(packTag);
            tag.func_74782_a(pack.defaults.section.id, (NBTBase)packTag);
        }
    }

    public static void readAllConfigsFromNBT(NBTTagCompound tag) {
        for (PackBase pack : ALL_PACKS) {
            NBTTagCompound packTag = tag.func_74775_l(pack.defaults.section.id);
            pack.readConfigFromNBT(packTag);
        }
    }

    public PackBase setFuelType(FuelType fuelType) {
        this.fuelType = fuelType;
        return this;
    }

    public PackBase setFuelFluid(String fuelFluid) {
        this.setFuelType(FuelType.FLUID);
        this.fuelFluid = fuelFluid;
        return this;
    }

    public PackBase setArmorModel(PackModelType armorModel) {
        this.armorModel = armorModel;
        return this;
    }

    public PackBase setShowInCreativeTab(boolean showInCreativeTab) {
        this.showInCreativeTab = showInCreativeTab;
        return this;
    }

    public PackBase setShowEmptyInCreativeTab(boolean showEmptyInCreativeTab) {
        this.showEmptyInCreativeTab = showEmptyInCreativeTab;
        return this;
    }

    public PackBase setUsesFuel(boolean usesFuel) {
        this.usesFuel = usesFuel;
        return this;
    }

    public PackBase setHasFuelIndicator(boolean hasFuelIndicator) {
        this.hasFuelIndicator = hasFuelIndicator;
        return this;
    }

    public PackBase setHasStateIndicators(boolean hasStateIndicators) {
        this.hasStateIndicators = hasStateIndicators;
        return this;
    }

    public PackBase setIsArmored(boolean isArmored) {
        this.isArmored = isArmored;
        return this;
    }

    public PackBase setShowArmored(boolean showArmored) {
        this.showArmored = showArmored;
        return this;
    }

    public PackBase setShowTier(boolean showTier) {
        this.showTier = showTier;
        return this;
    }

    public PackBase setPlatingMeta(int platingMeta) {
        this.platingMeta = platingMeta;
        return this;
    }

    public PackBase setFluxBased(boolean fluxBased) {
        this.isFluxBased = fluxBased;
        return this;
    }

    public void tickInventory(World world, EntityPlayer player, ItemStack stack, ItemPack item) {
    }

    public void tickArmor(World world, EntityPlayer player, ItemStack stack, ItemPack item) {
    }

    protected void chargeInventory(EntityLivingBase user, ItemStack stack, ItemPack item) {
        if (this.fuelType == FuelType.ENERGY) {
            for (int i = 0; i <= 5; ++i) {
                ItemStack currentStack = user.func_184582_a(EquipmentSlotHelper.fromSlot(i));
                if (currentStack == null || currentStack == stack || !(currentStack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem heldEnergyItem = (IEnergyContainerItem)currentStack.func_77973_b();
                if (this.usesFuel) {
                    int energyToAdd = Math.min(item.useFuel(stack, this.fuelPerTickOut, true), heldEnergyItem.receiveEnergy(currentStack, this.fuelPerTickOut, true));
                    item.useFuel(stack, energyToAdd, false);
                    heldEnergyItem.receiveEnergy(currentStack, energyToAdd, false);
                    continue;
                }
                heldEnergyItem.receiveEnergy(currentStack, this.fuelPerTickOut, false);
            }
        }
    }

    public String getBaseName(boolean armoredInfo) {
        return this.name + "." + this.tier + (armoredInfo && this.isArmored && this.showArmored ? ".armored" : "");
    }

    public String getRegistryName() {
        return this.registryName;
    }

    protected void toggleState(boolean on, ItemStack stack, String type, String tag, EntityPlayer player, boolean showInChat) {
        stack.func_77978_p().func_74757_a(tag, !on);
        if (player != null && showInChat) {
            String color = on ? "\u00a7c" : "\u00a7a";
            type = type != null && !type.equals("") ? "chat." + this.name + "." + type + ".on" : "chat." + this.name + ".on";
            String msg = SJStringHelper.localize(type, new Object[0]) + " " + color + SJStringHelper.localize("chat." + (on ? "disabled" : "enabled"), new Object[0]);
            player.func_145747_a((ITextComponent)new TextComponentString(msg));
        }
    }

    public boolean isOn(ItemStack stack) {
        return NBTHelper.getBooleanFallback(stack, TAG_ON, true);
    }

    public void togglePrimary(ItemStack stack, EntityPlayer player, boolean showInChat) {
        this.toggleState(this.isOn(stack), stack, null, TAG_ON, player, showInChat);
    }

    public void toggleSecondary(ItemStack stack, EntityPlayer player, boolean showInChat) {
    }

    public void switchModePrimary(ItemStack stack, EntityPlayer player, boolean showInChat) {
    }

    public void switchModeSecondary(ItemStack stack, EntityPlayer player, boolean showInChat) {
    }

    public String getGuiTitlePrefix() {
        return "gui.pack";
    }

    public ModKey[] getGuiControls() {
        return new ModKey[]{ModKey.TOGGLE_PRIMARY};
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, ModType modType) {
        String flat = Config.enableArmor3DModels || this.armorModel == PackModelType.FLAT ? "" : ".flat";
        return "simplyjetpacks:textures/armor/" + this.getBaseName(true) + modType.suffix + flat + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, ItemPack item, EntityPlayer player, List list) {
        if (this.showTier) {
            list.add(SJStringHelper.getTierText(this.tier));
        }
        list.add(SJStringHelper.getFuelText(this.fuelType, item.getFuelStored(stack), this.fuelCapacity, !this.usesFuel));
    }

    @SideOnly(value=Side.CLIENT)
    public void addShiftInformation(ItemStack stack, ItemPack item, EntityPlayer player, List list) {
        list.add(SJStringHelper.getStateText(this.isOn(stack)));
        String key = SimplyJetpacks.proxy.getPackGUIKey();
        if (key != null) {
            list.add(SJStringHelper.getPackGUIText(key));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addSubItems(ItemPack item, int meta, List list) {
        if (!this.showInCreativeTab) {
            return;
        }
        if (this.showEmptyInCreativeTab) {
            list.add(new ItemStack((Item)item, 1, meta));
        }
        ItemStack full = new ItemStack((Item)item, 1, meta);
        item.addFuel(full, item.getMaxFuelStored(full), false);
        list.add(full);
    }

    @SideOnly(value=Side.CLIENT)
    public String getHUDFuelInfo(ItemStack stack, ItemPack item) {
        int fuel = item.getFuelStored(stack);
        int maxFuel = item.getMaxFuelStored(stack);
        int percent = (int)Math.ceil((double)fuel / (double)maxFuel * 100.0);
        return SJStringHelper.getHUDFuelText(this.name, percent, this.fuelType, fuel);
    }

    @SideOnly(value=Side.CLIENT)
    public String getHUDStatesInfo(ItemStack stack, ItemPack item) {
        return null;
    }

    protected void loadConfig(Configuration config) {
        if (this.defaults.fuelCapacity != null) {
            this.fuelCapacity = config.get(this.defaults.section.name, "Fuel Capacity", this.defaults.fuelCapacity.intValue(), "The maximum amount of fuel that this pack can hold.").setMinValue(1).getInt(this.defaults.fuelCapacity.intValue());
        }
        if (this.defaults.fuelUsage != null) {
            this.fuelUsage = config.get(this.defaults.section.name, "Fuel Usage", this.defaults.fuelUsage.intValue(), "The amount of fuel that this pack uses every tick when used.").setMinValue(0).getInt(this.defaults.fuelUsage.intValue());
        }
        if (this.defaults.fuelPerTickIn != null) {
            this.fuelPerTickIn = config.get(this.defaults.section.name, "Fuel Per Tick In", this.defaults.fuelPerTickIn.intValue(), "The amount of fuel that can be inserted into this pack per tick from external sources.").setMinValue(0).getInt(this.defaults.fuelPerTickIn.intValue());
        }
        if (this.defaults.fuelPerTickOut != null) {
            this.fuelPerTickOut = config.get(this.defaults.section.name, "Fuel Per Tick Out", this.defaults.fuelPerTickOut.intValue(), "The amount of fuel that can be extracted from this pack per tick by external sources. Also determines how quickly Flux Packs can charge other items.").setMinValue(0).getInt(this.defaults.fuelPerTickOut.intValue());
        }
        if (this.defaults.armorReduction != null) {
            this.armorReduction = config.get(this.defaults.section.name, "Armor Reduction", this.defaults.armorReduction.intValue(), "How well this pack can protect the user from damage, if armored. The higher the value, the stronger the armor will be.").setMinValue(0).setMaxValue(20).getInt(this.defaults.armorReduction.intValue());
        }
        if (this.defaults.armorFuelPerHit != null) {
            this.armorFuelPerHit = config.get(this.defaults.section.name, "Armor Fuel Per Hit", this.defaults.armorFuelPerHit.intValue(), "How much fuel is lost from this pack when the user is hit, if armored.").setMinValue(0).getInt(this.defaults.armorFuelPerHit.intValue());
        }
        if (this.defaults.enchantability != null) {
            this.enchantability = config.get(this.defaults.section.name, "Enchantability", this.defaults.enchantability.intValue(), "The enchantability of this pack. If set to 0, no enchantments can be applied.").setMinValue(0).getInt(this.defaults.enchantability.intValue());
        }
    }

    protected void writeConfigToNBT(NBTTagCompound tag) {
        if (this.defaults.fuelCapacity != null) {
            tag.func_74768_a("FuelCapacity", this.fuelCapacity);
        }
        if (this.defaults.fuelUsage != null) {
            tag.func_74768_a("FuelUsage", this.fuelUsage);
        }
        if (this.defaults.fuelPerTickIn != null) {
            tag.func_74768_a("FuelPerTickIn", this.fuelPerTickIn);
        }
        if (this.defaults.fuelPerTickOut != null) {
            tag.func_74768_a("FuelPerTickOut", this.fuelPerTickOut);
        }
        if (this.defaults.armorReduction != null) {
            tag.func_74768_a("ArmorReduction", this.armorReduction);
        }
    }

    protected void readConfigFromNBT(NBTTagCompound tag) {
        if (this.defaults.fuelCapacity != null) {
            this.fuelCapacity = tag.func_74762_e("FuelCapacity");
        }
        if (this.defaults.fuelUsage != null) {
            this.fuelUsage = tag.func_74762_e("FuelUsage");
        }
        if (this.defaults.fuelPerTickIn != null) {
            this.fuelPerTickIn = tag.func_74762_e("FuelPerTickIn");
        }
        if (this.defaults.fuelPerTickOut != null) {
            this.fuelPerTickOut = tag.func_74762_e("FuelPerTickOut");
        }
        if (this.defaults.armorReduction != null) {
            this.armorReduction = tag.func_74762_e("ArmorReduction");
        }
    }
}

