/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.meta;

import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.handler.SyncHandler;
import tonius.simplyjetpacks.item.ItemPack;
import tonius.simplyjetpacks.item.meta.PackBase;
import tonius.simplyjetpacks.setup.FuelType;
import tonius.simplyjetpacks.setup.ModEnchantments;
import tonius.simplyjetpacks.setup.ModKey;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.util.NBTHelper;
import tonius.simplyjetpacks.util.SJStringHelper;
import tonius.simplyjetpacks.util.math.MathHelper;

public class Jetpack
extends PackBase {
    protected static final String TAG_HOVERMODE_ON = "JetpackHoverModeOn";
    protected static final String TAG_EHOVER_ON = "JetpackEHoverOn";
    protected static final String TAG_PARTICLE = "JetpackParticleType";
    public double speedVertical = 0.0;
    public double accelVertical = 0.0;
    public double speedVerticalHover = 0.0;
    public double speedVerticalHoverSlow = 0.0;
    public double speedSideways = 0.0;
    public double sprintSpeedModifier = 0.0;
    public double sprintFuelModifier = 0.0;
    public boolean emergencyHoverMode = false;
    public ParticleType defaultParticleType = ParticleType.DEFAULT;

    public Jetpack(int tier, EnumRarity rarity, String defaultConfigKey) {
        super("jetpack", tier, rarity, defaultConfigKey);
        this.setArmorModel(PackModelType.JETPACK);
    }

    public Jetpack setDefaultParticleType(ParticleType defaultParticleType) {
        this.defaultParticleType = defaultParticleType;
        return this;
    }

    @Override
    public void tickArmor(World world, EntityPlayer player, ItemStack stack, ItemPack item) {
        this.flyUser(player, stack, item, false);
    }

    public void flyUser(EntityPlayer user, ItemStack stack, ItemPack item, boolean force) {
        if (this.isOn(stack)) {
            boolean hoverMode = this.isHoverModeOn(stack);
            double hoverSpeed = Config.invertHoverSneakingBehavior == SyncHandler.isDescendKeyDown((EntityLivingBase)user) ? this.speedVerticalHoverSlow : this.speedVerticalHover;
            boolean flyKeyDown = force || SyncHandler.isFlyKeyDown((EntityLivingBase)user);
            boolean descendKeyDown = SyncHandler.isDescendKeyDown((EntityLivingBase)user);
            double currentAccel = this.accelVertical * (user.field_70181_x < 0.3 ? 2.5 : 1.0);
            double currentSpeedVertical = this.speedVertical * (user.func_70090_H() ? 0.4 : 1.0);
            if (flyKeyDown || hoverMode && !user.field_70122_E) {
                if (this.usesFuel) {
                    item.useFuel(stack, (int)(user.func_70051_ag() ? Math.round((double)this.getFuelUsage(stack) * this.sprintFuelModifier) : (long)this.getFuelUsage(stack)), false);
                }
                if (item.getFuelStored(stack) > 0) {
                    user.field_70181_x = flyKeyDown ? (!hoverMode ? Math.min(user.field_70181_x + currentAccel, currentSpeedVertical) : (descendKeyDown ? Math.min(user.field_70181_x + currentAccel, -this.speedVerticalHoverSlow) : Math.min(user.field_70181_x + currentAccel, this.speedVerticalHover))) : Math.min(user.field_70181_x + currentAccel, -hoverSpeed);
                    float speedSideways = (float)(user.func_70093_af() ? this.speedSideways * 0.5 : this.speedSideways);
                    float speedForward = (float)(user.func_70051_ag() ? (double)speedSideways * this.sprintSpeedModifier : (double)speedSideways);
                    if (SyncHandler.isForwardKeyDown((EntityLivingBase)user)) {
                        user.func_70060_a(0.0f, speedForward, speedForward);
                    }
                    if (SyncHandler.isBackwardKeyDown((EntityLivingBase)user)) {
                        user.func_70060_a(0.0f, -speedSideways, speedSideways * 0.8f);
                    }
                    if (SyncHandler.isLeftKeyDown((EntityLivingBase)user)) {
                        user.func_70060_a(speedSideways, 0.0f, speedSideways);
                    }
                    if (SyncHandler.isRightKeyDown((EntityLivingBase)user)) {
                        user.func_70060_a(-speedSideways, 0.0f, speedSideways);
                    }
                    if (!user.field_70170_p.field_72995_K) {
                        user.field_70143_R = 0.0f;
                    }
                }
            }
        }
        if (!(user.field_70170_p.field_72995_K || !this.emergencyHoverMode || !this.isEHoverOn(stack) || item.getEnergyStored(stack) <= 0 || this.isHoverModeOn(stack) && this.isOn(stack))) {
            if (user.field_70163_u < -5.0) {
                this.doEHover(stack, (EntityLivingBase)user);
            } else if (user instanceof EntityPlayer && !user.field_71075_bZ.field_75098_d && user.field_70143_R - 1.2f >= user.func_110143_aJ()) {
                for (int i = 0; i <= 16; ++i) {
                    int z;
                    int y;
                    int x = Math.round((float)user.field_70165_t - 0.5f);
                    if (user.field_70170_p.func_175623_d(new BlockPos(x, y = Math.round((float)user.field_70163_u) - i, z = Math.round((float)user.field_70161_v - 0.5f)))) continue;
                    this.doEHover(stack, (EntityLivingBase)user);
                    break;
                }
            }
        }
    }

    protected int getFuelUsage(ItemStack stack) {
        if (ModEnchantments.fuelEffeciency == null) {
            return this.fuelUsage;
        }
        int fuelEfficiencyLevel = MathHelper.clampI(EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.fuelEffeciency, (ItemStack)stack), 0, 4);
        return (int)Math.round((double)(this.fuelUsage * (20 - fuelEfficiencyLevel)) / 20.0);
    }

    public void doEHover(ItemStack armor, EntityLivingBase user) {
        NBTHelper.setBoolean(armor, "PackOn", true);
        NBTHelper.setBoolean(armor, TAG_HOVERMODE_ON, true);
        if (user instanceof EntityPlayer) {
            ((EntityPlayer)user).func_145747_a((ITextComponent)new TextComponentString("\u00a7c" + SJStringHelper.localize("chat.jetpack.emergencyHoverMode.msg", new Object[0])));
        }
    }

    public void setMobMode(ItemStack itemStack) {
        itemStack.func_77978_p().func_74757_a("PackOn", true);
        itemStack.func_77978_p().func_74757_a(TAG_HOVERMODE_ON, false);
    }

    public boolean isHoverModeOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_HOVERMODE_ON);
    }

    public boolean isEHoverOn(ItemStack stack) {
        return NBTHelper.getBoolean(stack, TAG_EHOVER_ON);
    }

    @Override
    public void switchModePrimary(ItemStack stack, EntityPlayer player, boolean showInChat) {
        this.switchHoverMode(stack, player, showInChat);
    }

    @Override
    public void switchModeSecondary(ItemStack stack, EntityPlayer player, boolean showInChat) {
        if (this.emergencyHoverMode) {
            this.switchEHover(stack, player, showInChat);
        }
    }

    protected void switchHoverMode(ItemStack stack, EntityPlayer player, boolean showInChat) {
        this.toggleState(this.isHoverModeOn(stack), stack, "hoverMode", TAG_HOVERMODE_ON, player, showInChat);
    }

    public void switchEHover(ItemStack stack, EntityPlayer player, boolean showInChat) {
        this.toggleState(this.isEHoverOn(stack), stack, "emergencyHoverMode", TAG_EHOVER_ON, player, showInChat);
    }

    public void setParticleType(ItemStack stack, ParticleType particle) {
        NBTHelper.setInt(stack, TAG_PARTICLE, particle.ordinal());
    }

    protected ParticleType getParticleType(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(TAG_PARTICLE)) {
            int particle = NBTHelper.getInt(stack, TAG_PARTICLE);
            ParticleType particleType = ParticleType.values()[particle];
            if (particleType != null) {
                return particleType;
            }
        }
        NBTHelper.setInt(stack, TAG_PARTICLE, this.defaultParticleType.ordinal());
        return this.defaultParticleType;
    }

    public ParticleType getDisplayParticleType(ItemStack stack, ItemPack item, EntityLivingBase user) {
        boolean flyKeyDown = SyncHandler.isFlyKeyDown(user);
        if (this.isOn(stack) && item.getFuelStored(stack) > 0 && (flyKeyDown || this.isHoverModeOn(stack) && !user.field_70122_E && user.field_70181_x < 0.0)) {
            return this.getParticleType(stack);
        }
        return null;
    }

    @Override
    public String getGuiTitlePrefix() {
        return "gui.jetpack";
    }

    @Override
    public ModKey[] getGuiControls() {
        if (this.emergencyHoverMode) {
            return new ModKey[]{ModKey.TOGGLE_PRIMARY, ModKey.MODE_PRIMARY, ModKey.MODE_SECONDARY};
        }
        return new ModKey[]{ModKey.TOGGLE_PRIMARY, ModKey.MODE_PRIMARY};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addShiftInformation(ItemStack stack, ItemPack item, EntityPlayer player, List list) {
        list.add(SJStringHelper.getStateText(this.isOn(stack)));
        list.add(SJStringHelper.getHoverModeText(this.isHoverModeOn(stack)));
        if (this.fuelType == FuelType.FLUID && this.fuelFluid != null) {
            list.add(SJStringHelper.getFuelFluidText(this.fuelFluid));
        }
        if (this.fuelUsage > 0) {
            list.add(SJStringHelper.getFuelUsageText(this.fuelType, this.getFuelUsage(stack)));
        }
        list.add(SJStringHelper.getParticlesText(this.getParticleType(stack)));
        SJStringHelper.addDescriptionLines(list, "jetpack", "\u00a7a");
        String key = SimplyJetpacks.proxy.getPackGUIKey();
        if (key != null) {
            list.add(SJStringHelper.getPackGUIText(key));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHUDStatesInfo(ItemStack stack, ItemPack item) {
        Boolean engine = this.isOn(stack);
        Boolean hover = this.isHoverModeOn(stack);
        return SJStringHelper.getHUDStateText(engine, hover, null);
    }

    @Override
    protected void loadConfig(Configuration config) {
        super.loadConfig(config);
        if (this.defaults.speedVertical != null) {
            this.speedVertical = config.get(this.defaults.section.name, "Vertical Speed", this.defaults.speedVertical.doubleValue(), "The maximum vertical speed of this jetpack when flying.").setMinValue(0.0).getDouble(this.defaults.speedVertical.doubleValue());
        }
        if (this.defaults.accelVertical != null) {
            this.accelVertical = config.get(this.defaults.section.name, "Vertical Acceleration", this.defaults.accelVertical.doubleValue(), "The vertical acceleration of this jetpack when flying; every tick, this amount of vertical speed will be added until maximum speed is reached.").setMinValue(0.0).getDouble(this.defaults.accelVertical.doubleValue());
        }
        if (this.defaults.speedVerticalHover != null) {
            this.speedVerticalHover = config.get(this.defaults.section.name, "Vertical Speed (Hover Mode)", this.defaults.speedVerticalHover.doubleValue(), "The maximum vertical speed of this jetpack when flying in hover mode.").setMinValue(0.0).getDouble(this.defaults.speedVerticalHover.doubleValue());
        }
        if (this.defaults.speedVerticalHoverSlow != null) {
            this.speedVerticalHoverSlow = config.get(this.defaults.section.name, "Vertical Speed (Hover Mode / Slow Descent)", this.defaults.speedVerticalHoverSlow.doubleValue(), "The maximum vertical speed of this jetpack when slowly descending in hover mode.").setMinValue(0.0).getDouble(this.defaults.speedVerticalHoverSlow.doubleValue());
        }
        if (this.defaults.speedSideways != null) {
            this.speedSideways = config.get(this.defaults.section.name, "Sideways Speed", this.defaults.speedSideways.doubleValue(), "The speed of this jetpack when flying sideways. This is mostly noticeable in hover mode.").setMinValue(0.0).getDouble(this.defaults.speedSideways.doubleValue());
        }
        if (this.defaults.sprintSpeedModifier != null) {
            this.sprintSpeedModifier = config.get(this.defaults.section.name, "Sprint Speed Multiplier", this.defaults.sprintSpeedModifier.doubleValue(), "How much faster this jetpack will fly forward when sprinting. Setting this to 1.0 will make sprinting have no effect apart from the added speed from vanilla.").setMinValue(0.0).getDouble(this.defaults.sprintSpeedModifier.doubleValue());
        }
        if (this.defaults.sprintFuelModifier != null) {
            this.sprintFuelModifier = config.get(this.defaults.section.name, "Sprint Fuel Usage Multiplier", this.defaults.sprintFuelModifier.doubleValue(), "How much more energy this jetpack will use when sprinting. Setting this to 1.0 will make sprinting have no effect on energy usage.").setMinValue(0.0).getDouble(this.defaults.sprintFuelModifier.doubleValue());
        }
        if (this.defaults.emergencyHoverMode != null) {
            this.emergencyHoverMode = config.get(this.defaults.section.name, "Emergency Hover Mode", this.defaults.emergencyHoverMode.booleanValue(), "When enabled, this jetpack will activate hover mode automatically when the wearer is about to die from a fall.").getBoolean(this.defaults.emergencyHoverMode.booleanValue());
        }
    }

    @Override
    protected void writeConfigToNBT(NBTTagCompound tag) {
        super.writeConfigToNBT(tag);
        if (this.defaults.speedVertical != null) {
            tag.func_74780_a("SpeedVertical", this.speedVertical);
        }
        if (this.defaults.accelVertical != null) {
            tag.func_74780_a("AccelVertical", this.accelVertical);
        }
        if (this.defaults.speedVerticalHover != null) {
            tag.func_74780_a("SpeedVerticalHover", this.speedVerticalHover);
        }
        if (this.defaults.speedVerticalHoverSlow != null) {
            tag.func_74780_a("SpeedVerticalHoverSlow", this.speedVerticalHoverSlow);
        }
        if (this.defaults.speedSideways != null) {
            tag.func_74780_a("SpeedSideways", this.speedSideways);
        }
        if (this.defaults.sprintSpeedModifier != null) {
            tag.func_74780_a("SprintSpeedModifier", this.sprintSpeedModifier);
        }
        if (this.defaults.sprintFuelModifier != null) {
            tag.func_74780_a("SprintFuelModifier", this.sprintFuelModifier);
        }
        if (this.defaults.emergencyHoverMode != null) {
            tag.func_74757_a("EmergencyHoverMode", this.emergencyHoverMode);
        }
    }

    @Override
    protected void readConfigFromNBT(NBTTagCompound tag) {
        super.readConfigFromNBT(tag);
        if (this.defaults.speedVertical != null) {
            this.speedVertical = tag.func_74769_h("SpeedVertical");
        }
        if (this.defaults.accelVertical != null) {
            this.accelVertical = tag.func_74769_h("AccelVertical");
        }
        if (this.defaults.speedVerticalHover != null) {
            this.speedVerticalHover = tag.func_74769_h("SpeedVerticalHover");
        }
        if (this.defaults.speedVerticalHoverSlow != null) {
            this.speedVerticalHoverSlow = tag.func_74769_h("SpeedVerticalHoverSlow");
        }
        if (this.defaults.speedSideways != null) {
            this.speedSideways = tag.func_74769_h("SpeedSideways");
        }
        if (this.defaults.sprintSpeedModifier != null) {
            this.sprintSpeedModifier = tag.func_74769_h("SprintSpeedModifier");
        }
        if (this.defaults.sprintFuelModifier != null) {
            this.sprintFuelModifier = tag.func_74769_h("SprintFuelModifier");
        }
        if (this.defaults.emergencyHoverMode != null) {
            this.emergencyHoverMode = tag.func_74767_n("EmergencyHoverMode");
        }
    }
}

