/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item.meta;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.item.ItemPack;
import tonius.simplyjetpacks.item.meta.PackBase;
import tonius.simplyjetpacks.setup.FuelType;
import tonius.simplyjetpacks.util.SJStringHelper;

public class FluxPack
extends PackBase {
    public FluxPack(int tier, EnumRarity rarity, String defaultConfigKey) {
        super("fluxpack", tier, rarity, defaultConfigKey);
        this.setFuelType(FuelType.ENERGY);
        this.setArmorModel(PackModelType.FLUX_PACK);
    }

    @Override
    public void tickArmor(World world, EntityPlayer player, ItemStack stack, ItemPack item) {
        if (this.isOn(stack)) {
            this.chargeInventory((EntityLivingBase)player, stack, item);
        }
    }

    @Override
    public String getGuiTitlePrefix() {
        return "gui.fluxpack";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addShiftInformation(ItemStack stack, ItemPack item, EntityPlayer player, List list) {
        list.add(SJStringHelper.getStateText(this.isOn(stack)));
        list.add(SJStringHelper.getEnergySendText(this.fuelPerTickOut));
        if (this.fuelPerTickIn > 0) {
            list.add(SJStringHelper.getEnergyReceiveText(this.fuelPerTickIn));
        }
        SJStringHelper.addDescriptionLines(list, "fluxpack", "\u00a7a");
        String key = SimplyJetpacks.proxy.getPackGUIKey();
        if (key != null) {
            list.add(SJStringHelper.getPackGUIText(key));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getHUDStatesInfo(ItemStack stack, ItemPack item) {
        return SJStringHelper.getHUDStateText(null, null, this.isOn(stack));
    }
}

