/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import tonius.simplyjetpacks.SimplyJetpacks;
import tonius.simplyjetpacks.item.ItemRegistered;
import tonius.simplyjetpacks.setup.ModCreativeTab;
import tonius.simplyjetpacks.util.SJStringHelper;

public class ItemMeta
extends ItemRegistered {
    protected final Map<Integer, MetaItem> metaItems = new HashMap<Integer, MetaItem>();
    protected int highestMeta = 0;
    protected String name;

    public ItemMeta(String registryName) {
        super(registryName);
        registryName = this.name;
        this.func_77655_b("simplyjetpacks." + registryName);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(ModCreativeTab.instance);
    }

    public MetaItem getMetaItem(ItemStack itemStack) {
        return this.metaItems.get(itemStack.func_77952_i());
    }

    public ItemStack addMetaItem(int index, MetaItem item, boolean registerOreDict) {
        if (item == null) {
            return null;
        }
        this.metaItems.put(index, item);
        ItemStack itemStack = new ItemStack((Item)this, 1, index);
        if (index > this.highestMeta) {
            this.highestMeta = index;
        }
        if (registerOreDict) {
            OreDictionary.registerOre((String)item.name, (ItemStack)itemStack);
        }
        return itemStack;
    }

    public String func_77667_c(ItemStack itemStack) {
        MetaItem metaItem = this.getMetaItem(itemStack);
        if (metaItem != null) {
            return "item.simplyjetpacks." + metaItem.name;
        }
        return super.func_77658_a();
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        MetaItem metaItem = this.getMetaItem(itemStack);
        if (metaItem != null) {
            return metaItem.rarity;
        }
        return super.func_77613_e(itemStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        MetaItem metaItem = this.getMetaItem(itemStack);
        if (metaItem != null && metaItem.tooltipKey != null) {
            if (SJStringHelper.canShowDetails()) {
                SJStringHelper.addDescriptionLines(list, metaItem.tooltipKey, "\u00a77");
            } else {
                list.add(SJStringHelper.getShiftText());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i <= this.highestMeta; ++i) {
            MetaItem metaItem = this.metaItems.get(i);
            if (metaItem == null || metaItem.hidden) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack itemStack) {
        MetaItem metaItem = this.getMetaItem(itemStack);
        if (metaItem != null && metaItem.glow) {
            return true;
        }
        return super.func_77636_d(itemStack);
    }

    public void registerItemModel() {
        for (int i = 0; i <= this.highestMeta; ++i) {
            SimplyJetpacks.proxy.registerItemRenderer(this, i, this.name);
        }
    }

    public static class MetaItem {
        public final String name;
        public final String tooltipKey;
        public final EnumRarity rarity;
        public final boolean glow;
        public final boolean hidden;

        public MetaItem(String name, String tooltipKey, EnumRarity rarity, boolean glow, boolean hidden) {
            this.name = name;
            this.tooltipKey = tooltipKey;
            this.rarity = rarity;
            this.glow = glow;
            this.hidden = hidden;
        }

        public MetaItem(String name, String tooltipKey, EnumRarity rarity) {
            this(name, tooltipKey, rarity, false, false);
        }
    }
}

