/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.api.stack.PositionedStack;
import codechicken.nei.recipe.FurnaceRecipeHandler;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import codechicken.nei.util.NEIClientUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class FuelRecipeHandler
extends FurnaceRecipeHandler {
    private ArrayList<FurnaceRecipeHandler.SmeltingPair> mfurnace = new ArrayList();

    public FuelRecipeHandler() {
        this.loadAllSmelting();
    }

    @Override
    public String getRecipeName() {
        return NEIClientUtils.translate("recipe.fuel", new Object[0]);
    }

    private void loadAllSmelting() {
        Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry recipe : recipes.entrySet()) {
            this.mfurnace.add(new FurnaceRecipeHandler.SmeltingPair(this, (ItemStack)recipe.getKey(), (ItemStack)recipe.getValue()));
        }
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fuel") && this.getClass() == FuelRecipeHandler.class) {
            for (FurnaceRecipeHandler.FuelPair fuel : afuels) {
                this.arecipes.add(new CachedFuelRecipe(fuel));
            }
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (FurnaceRecipeHandler.FuelPair fuel : afuels) {
            if (!fuel.stack.contains(ingredient)) continue;
            this.arecipes.add(new CachedFuelRecipe(fuel));
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "fuel";
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        CachedFuelRecipe crecipe = (CachedFuelRecipe)this.arecipes.get(recipe);
        FurnaceRecipeHandler.FuelPair fuel = crecipe.fuel;
        float burnTime = (float)fuel.burnTime / 200.0f;
        if (gui.isMouseOver(fuel.stack, recipe) && burnTime < 1.0f) {
            burnTime = 1.0f / burnTime;
            String s_time = Float.toString(burnTime);
            if (burnTime == (float)Math.round(burnTime)) {
                s_time = Integer.toString((int)burnTime);
            }
            currenttip.add(NEIClientUtils.translate("recipe.fuel.required", s_time));
        } else if ((gui.isMouseOver(crecipe.getResult(), recipe) || gui.isMouseOver(crecipe.getIngredient(), recipe)) && burnTime > 1.0f) {
            String s_time = Float.toString(burnTime);
            if (burnTime == (float)Math.round(burnTime)) {
                s_time = Integer.toString((int)burnTime);
            }
            currenttip.add(NEIClientUtils.translate("recipe.fuel." + (gui.isMouseOver(crecipe.getResult(), recipe) ? "produced" : "processed"), s_time));
        }
        return currenttip;
    }

    public class CachedFuelRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public FurnaceRecipeHandler.FuelPair fuel;

        public CachedFuelRecipe(FurnaceRecipeHandler.FuelPair fuel) {
            super(FuelRecipeHandler.this);
            this.fuel = fuel;
        }

        @Override
        public PositionedStack getIngredient() {
            return ((FurnaceRecipeHandler.SmeltingPair)((FuelRecipeHandler)FuelRecipeHandler.this).mfurnace.get((int)(FuelRecipeHandler.this.cycleticks / 48 % ((FuelRecipeHandler)FuelRecipeHandler.this).mfurnace.size()))).ingred;
        }

        @Override
        public PositionedStack getResult() {
            return ((FurnaceRecipeHandler.SmeltingPair)((FuelRecipeHandler)FuelRecipeHandler.this).mfurnace.get((int)(FuelRecipeHandler.this.cycleticks / 48 % ((FuelRecipeHandler)FuelRecipeHandler.this).mfurnace.size()))).result;
        }

        @Override
        public PositionedStack getOtherStack() {
            return this.fuel.stack;
        }
    }
}

