/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.jei;

import codechicken.lib.config.ConfigTagParent;
import codechicken.nei.VisibilityData;
import codechicken.nei.jei.EnumItemBrowser;
import codechicken.nei.jei.proxy.JEIProxy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.JeiRuntime;
import mezz.jei.RecipeRegistry;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.config.Config;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.ItemListOverlay;
import mezz.jei.gui.ItemListOverlayInternal;
import mezz.jei.input.GuiTextFieldFilter;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIIntegrationManager
extends BlankModPlugin {
    public static final JEIProxy proxy = new JEIProxy();
    public static IIngredientBlacklist jeiBlacklist;
    public static EnumItemBrowser searchBoxOwner;
    public static EnumItemBrowser recipePriority;
    public static EnumItemBrowser itemPannelOwner;

    public static void pushChanges(VisibilityData data) {
        JeiRuntime runtime = Internal.getRuntime();
        ItemListOverlay overlay = runtime.getItemListOverlay();
        GuiTextFieldFilter fieldFilter = JEIIntegrationManager.getTextFieldFilter(overlay.getInternal());
        if (searchBoxOwner == EnumItemBrowser.JEI) {
            data.showSearchSection = false;
            if (fieldFilter != null) {
                fieldFilter.func_146189_e(true);
            }
        } else {
            data.showSearchSection = true;
            if (fieldFilter != null) {
                fieldFilter.func_146189_e(false);
            }
        }
        if (itemPannelOwner == EnumItemBrowser.JEI) {
            data.showItemPanel = false;
            if (!Config.isOverlayEnabled()) {
                Config.toggleOverlayEnabled();
            }
        } else {
            data.showSearchSection = true;
            data.showItemPanel = true;
            if (Config.isOverlayEnabled()) {
                Config.toggleOverlayEnabled();
            }
        }
    }

    public void register(IModRegistry registry) {
        jeiBlacklist = registry.getJeiHelpers().getIngredientBlacklist();
    }

    public static void initConfig(ConfigTagParent tag) {
        JEIIntegrationManager.setItemPanelOwner(tag.getTag("jei.itemPanel").getIntValue(1));
        JEIIntegrationManager.setSearchBoxOwner(tag.getTag("jei.searchBox").getIntValue(1));
    }

    public static boolean openRecipeGui(ItemStack stack) {
        IFocus focus;
        RecipeRegistry registry = Internal.getRuntime().getRecipeRegistry();
        if (registry.getRecipeCategories(focus = registry.createFocus(IFocus.Mode.OUTPUT, (Object)stack)).isEmpty()) {
            return false;
        }
        Internal.getRuntime().getRecipesGui().show(focus);
        return false;
    }

    public static boolean openUsageGui(ItemStack stack) {
        IFocus focus;
        RecipeRegistry registry = Internal.getRuntime().getRecipeRegistry();
        if (registry.getRecipeCategories(focus = registry.createFocus(IFocus.Mode.INPUT, (Object)stack)).isEmpty()) {
            return false;
        }
        Internal.getRuntime().getRecipesGui().show(focus);
        return false;
    }

    public static boolean setSearchBoxOwner(int ordinal) {
        try {
            searchBoxOwner = EnumItemBrowser.values()[ordinal];
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            searchBoxOwner = EnumItemBrowser.NEI;
            return false;
        }
    }

    public static boolean setSearchBoxOwner(EnumItemBrowser browser) {
        searchBoxOwner = browser;
        return true;
    }

    public static boolean setItemPanelOwner(EnumItemBrowser browser) {
        itemPannelOwner = browser;
        return true;
    }

    public static boolean setItemPanelOwner(int ordinal) {
        try {
            itemPannelOwner = EnumItemBrowser.values()[ordinal];
            return true;
        }
        catch (IndexOutOfBoundsException e) {
            itemPannelOwner = EnumItemBrowser.NEI;
            return false;
        }
    }

    public static ItemListOverlayInternal getItemListOverlayInternal() {
        if (Internal.getRuntime() == null || Internal.getRuntime().getItemListOverlay().getInternal() == null) {
            return null;
        }
        return Internal.getRuntime().getItemListOverlay().getInternal();
    }

    public static GuiTextFieldFilter getTextFieldFilter() {
        if (Internal.getRuntime() == null || Internal.getRuntime().getItemListOverlay().getInternal() == null) {
            return null;
        }
        return JEIIntegrationManager.getTextFieldFilter(Internal.getRuntime().getItemListOverlay().getInternal());
    }

    private static GuiTextFieldFilter getTextFieldFilter(ItemListOverlayInternal overlay) {
        if (overlay == null) {
            return null;
        }
        try {
            Field field = overlay.getClass().getDeclaredField("searchField");
            field.setAccessible(true);
            return (GuiTextFieldFilter)field.get(overlay);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ItemFilter getItemFilter(GuiTextFieldFilter fieldFilter) {
        if (fieldFilter == null) {
            return null;
        }
        try {
            Field field = fieldFilter.getClass().getDeclaredField("itemFilter");
            field.setAccessible(true);
            return (ItemFilter)field.get(fieldFilter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setFilterText(String text) {
        ItemListOverlay overlay = Internal.getRuntime().getItemListOverlay();
        overlay.setFilterText(text);
    }

    public static List<ItemStack> getFilteredItems() {
        ItemListOverlay overlay = Internal.getRuntime().getItemListOverlay();
        ItemFilter filter = JEIIntegrationManager.getItemFilter(JEIIntegrationManager.getTextFieldFilter(overlay.getInternal()));
        if (filter != null) {
            return filter.getItemStacks();
        }
        return new ArrayList<ItemStack>();
    }

    public static boolean isItemBlacklistedJEI(ItemStack stack) {
        if (jeiBlacklist != null) {
            return jeiBlacklist.isIngredientBlacklisted((Object)stack);
        }
        return false;
    }

    public static KeyBinding getShowUses() {
        return KeyBindings.showUses;
    }

    public static KeyBinding getShowRecipes() {
        return KeyBindings.showRecipe;
    }

    public static KeyBinding getFocusSearch() {
        return KeyBindings.focusSearch;
    }

    public static KeyBinding getRecipeBack() {
        return KeyBindings.recipeBack;
    }

    public static KeyBinding getToggleOverlay() {
        return KeyBindings.toggleOverlay;
    }

    static {
        searchBoxOwner = EnumItemBrowser.JEI;
        recipePriority = EnumItemBrowser.NEI;
        itemPannelOwner = EnumItemBrowser.JEI;
    }
}

