/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.nei.jei.JEIIntegrationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyBindings {
    private static final String categoryNameGui = "NEI (Not Enough Items) Gui";
    private static final String categoryNameWorld = "NEI (Not Enough Items) World";
    private static Map<String, KeyBinding> keyBindings = new HashMap<String, KeyBinding>();
    private static List<KeyBinding> keyBindingsToRegister = new ArrayList<KeyBinding>();

    public static KeyBinding get(String string) {
        KeyBinding keyBinding = keyBindings.get(string);
        if (keyBinding == null) {
            throw new IllegalArgumentException("There is no key binding for " + string);
        }
        return keyBinding;
    }

    @Deprecated
    public static void setDefaultKeyBinding(String string, int key) {
        KeyBinding keyBinding = new KeyBinding(string, (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, key, "misc");
        keyBindings.put(string, keyBinding);
        keyBindingsToRegister.add(keyBinding);
    }

    public static void setDefaultKeyBinding(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode, String category) {
        KeyBinding keyBinding = new KeyBinding(description, keyConflictContext, keyModifier, keyCode, category);
        keyBindings.put(description, keyBinding);
        keyBindingsToRegister.add(keyBinding);
    }

    public static void setDefaultKeyBinding(String description, KeyBinding keyBinding) {
        keyBindings.put(description, keyBinding);
    }

    public static void register() {
        for (KeyBinding keyBinding : keyBindingsToRegister) {
            ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        }
    }

    static {
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.recipe", JEIIntegrationManager.getShowRecipes());
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.usage", JEIIntegrationManager.getShowUses());
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.back", JEIIntegrationManager.getRecipeBack());
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.enchant", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 45, categoryNameGui);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.potion", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 25, categoryNameGui);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.prev", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 201, categoryNameGui);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.next", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 209, categoryNameGui);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.hide", JEIIntegrationManager.getToggleOverlay());
        KeyBindings.setDefaultKeyBinding("nei.options.keys.gui.search", JEIIntegrationManager.getFocusSearch());
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.chunkoverlay", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 67, categoryNameWorld);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.moboverlay", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 65, categoryNameWorld);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.dawn", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, categoryNameWorld);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.noon", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, categoryNameWorld);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.dusk", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, categoryNameWorld);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.midnight", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, categoryNameWorld);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.rain", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, categoryNameWorld);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.heal", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, categoryNameWorld);
        KeyBindings.setDefaultKeyBinding("nei.options.keys.world.creative", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 0, categoryNameWorld);
    }
}

