/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.util;

import com.latmod.yabba.YabbaCommon;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.IBarrelModifiable;
import com.latmod.yabba.api.IUpgrade;
import com.latmod.yabba.util.Tier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;

public enum EnumUpgrade implements IUpgrade,
IStringSerializable
{
    BLANK(0, "blank"),
    IRON_UPGRADE(1, "iron_upgrade"),
    GOLD_UPGRADE(2, "gold_upgrade"),
    DIAMOND_UPGRADE(3, "diamond_upgrade"),
    NETHER_STAR_UPGRADE(4, "nether_star_upgrade"),
    CREATIVE(9, "creative"),
    OBSIDIAN_SHELL(11, "obsidian_shell"),
    REDSTONE_OUT(12, "redstone_out"),
    HOPPER(13, "hopper"),
    VOID(15, "void");

    public static final EnumUpgrade[] VALUES;
    private final String name;
    public final String uname;
    public final int metadata;

    private EnumUpgrade(int meta, String n2) {
        this.name = n2;
        this.uname = "item.yabba.upgrade." + this.name;
        this.metadata = meta;
    }

    public String func_176610_l() {
        return this.name;
    }

    public ItemStack item() {
        return new ItemStack((Item)YabbaItems.UPGRADE, 1, this.metadata);
    }

    public static EnumUpgrade getFromMeta(int meta) {
        for (EnumUpgrade t : VALUES) {
            if (t.metadata != meta) continue;
            return t;
        }
        return BLANK;
    }

    @Override
    public boolean applyOn(IBarrelModifiable barrel, World worldIn, ItemStack upgradeItem, boolean simulate) {
        switch (this) {
            case IRON_UPGRADE: {
                if (!barrel.getTier().equals(Tier.WOOD)) break;
                if (!simulate) {
                    barrel.setTier(YabbaCommon.TIER_IRON);
                }
                return true;
            }
            case GOLD_UPGRADE: {
                if (!barrel.getTier().equals(YabbaCommon.TIER_IRON)) break;
                if (!simulate) {
                    barrel.setTier(YabbaCommon.TIER_GOLD);
                }
                return true;
            }
            case DIAMOND_UPGRADE: {
                if (!barrel.getTier().equals(YabbaCommon.TIER_GOLD)) break;
                if (!simulate) {
                    barrel.setTier(YabbaCommon.TIER_DMD);
                }
                return true;
            }
            case NETHER_STAR_UPGRADE: {
                if (barrel.getFlag(16)) break;
                if (!simulate) {
                    barrel.setFlag(16, true);
                    barrel.addUpgradeName(EnumUpgrade.NETHER_STAR_UPGRADE.uname);
                }
                return true;
            }
            case CREATIVE: {
                if (barrel.getFlag(8) || barrel.getStackInSlot(0) == null) break;
                if (!simulate) {
                    barrel.setItemCount(1000000000);
                    barrel.setFlag(8, true);
                    barrel.setFlag(16, true);
                    barrel.setFlag(1, false);
                    barrel.addUpgradeName(EnumUpgrade.CREATIVE.uname);
                }
                return true;
            }
            case OBSIDIAN_SHELL: {
                if (barrel.getFlag(32)) break;
                if (!simulate) {
                    barrel.setFlag(32, true);
                    barrel.addUpgradeName(EnumUpgrade.OBSIDIAN_SHELL.uname);
                }
                return true;
            }
            case REDSTONE_OUT: {
                if (barrel.getFlag(64)) break;
                if (!simulate) {
                    barrel.setFlag(64, true);
                    barrel.setUpgradeData("RedstoneMode", (NBTBase)new NBTTagByte(0));
                    barrel.setUpgradeData("RedstoneItemCount", (NBTBase)new NBTTagInt(0));
                    barrel.addUpgradeName(EnumUpgrade.REDSTONE_OUT.uname);
                }
                return true;
            }
            case HOPPER: {
                if (barrel.getFlag(128)) break;
                if (!simulate) {
                    barrel.setFlag(128, true);
                    barrel.setUpgradeData("HopperUp", (NBTBase)new NBTTagByte(1));
                    barrel.setUpgradeData("HopperDown", (NBTBase)new NBTTagByte(1));
                    barrel.setUpgradeData("HopperCollect", (NBTBase)new NBTTagByte(0));
                    barrel.addUpgradeName(EnumUpgrade.HOPPER.uname);
                }
                return true;
            }
            case VOID: {
                if (barrel.getFlag(2)) break;
                if (!simulate) {
                    barrel.setFlag(2, true);
                    barrel.addUpgradeName(EnumUpgrade.VOID.uname);
                }
                return true;
            }
        }
        return false;
    }

    static {
        VALUES = EnumUpgrade.values();
    }
}

