/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.util;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.latmod.yabba.YabbaConfig;
import com.latmod.yabba.api.IBarrel;
import com.latmod.yabba.api.IBarrelModifiable;
import com.latmod.yabba.api.ITier;
import gnu.trove.map.hash.TIntByteHashMap;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public abstract class Barrel
implements IBarrelModifiable {
    private static final TIntByteHashMap ALLOWED_ORE_NAME_CACHE = new TIntByteHashMap();

    public static void clearCache() {
        ALLOWED_ORE_NAME_CACHE.clear();
    }

    private static boolean isOreNameAllowed(int id) {
        byte b = ALLOWED_ORE_NAME_CACHE.get(id);
        if (b == 0) {
            b = 2;
            String name = OreDictionary.getOreName((int)id);
            for (IConfigValue v : YabbaConfig.ALLOWED_ORE_PREFIXES.getList()) {
                if (!name.startsWith(v.getString())) continue;
                b = 1;
                break;
            }
            ALLOWED_ORE_NAME_CACHE.put(id, b);
        }
        return b == 1;
    }

    private static boolean canInsertItem(ItemStack stored, ItemStack stack, boolean checkOreNames) {
        if (stored.func_77973_b() != stack.func_77973_b() || stored.func_77960_j() != stack.func_77960_j() || stored.func_77952_i() != stack.func_77952_i()) {
            return checkOreNames && Barrel.canInsertOreItem(stored, stack);
        }
        NBTTagCompound tag1 = stored.func_77978_p();
        NBTTagCompound tag2 = stack.func_77978_p();
        return Objects.equals(tag1 == null || tag1.func_82582_d() ? null : tag1, tag2 == null || tag2.func_82582_d() ? null : tag2) && stored.areCapsCompatible(stack) || checkOreNames && Barrel.canInsertOreItem(stored, stack);
    }

    private static boolean canInsertOreItem(ItemStack stored, ItemStack stack) {
        int[] storedIDs = OreDictionary.getOreIDs((ItemStack)stored);
        if (storedIDs.length != 1) {
            return false;
        }
        int[] stackIDs = OreDictionary.getOreIDs((ItemStack)stack);
        return stackIDs.length == 1 && storedIDs[0] == stackIDs[0] && Barrel.isOreNameAllowed(stackIDs[0]);
    }

    @Override
    public boolean getFlag(int flag) {
        if (flag == 512) {
            return YabbaConfig.ALWAYS_DISPLAY_DATA.get().get(Bits.getFlag((int)this.getFlags(), (int)512));
        }
        if (flag == 1024) {
            return YabbaConfig.DISPLAY_BAR.get().get(Bits.getFlag((int)this.getFlags(), (int)1024));
        }
        return Bits.getFlag((int)this.getFlags(), (int)flag);
    }

    @Override
    public void setFlag(int flag, boolean v) {
        this.setFlags(Bits.setFlag((int)this.getFlags(), (int)flag, (boolean)v));
    }

    public int getSlots() {
        return 1;
    }

    @Nullable
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int capacity;
        boolean canInsert;
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        ItemStack storedItem = this.getStackInSlot(0);
        boolean bl = storedItem == null || Barrel.canInsertItem(storedItem, stack, !this.getFlag(4)) ? true : (canInsert = false);
        if (storedItem != null && this.getFlag(8)) {
            return canInsert ? null : stack;
        }
        ITier tier = this.getTier();
        int itemCount = this.getItemCount();
        if (itemCount > 0) {
            capacity = tier.getMaxItems(this, storedItem);
            if (itemCount >= capacity) {
                return canInsert && this.getFlag(2) ? null : stack;
            }
        } else {
            capacity = tier.getMaxItems(this, stack);
        }
        if (canInsert) {
            int size = Math.min(stack.field_77994_a, capacity - itemCount);
            if (size > 0 && !simulate) {
                boolean full = false;
                if (storedItem == null) {
                    this.setStackInSlot(0, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                    this.setItemCount(0);
                    full = true;
                }
                this.setItemCount(itemCount + size);
                this.markBarrelDirty(full);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.field_77994_a - size));
        }
        return stack;
    }

    @Nullable
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int itemCount = this.getItemCount();
        if (amount <= 0 || itemCount <= 0) {
            return null;
        }
        ItemStack storedItem = this.getStackInSlot(0);
        if (storedItem == null) {
            return null;
        }
        if (this.getFlag(8)) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)storedItem, (int)Math.min(amount, itemCount));
        }
        ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)storedItem, (int)Math.min(Math.min(amount, itemCount), storedItem.func_77976_d()));
        if (!simulate) {
            this.setItemCount(itemCount - stack.field_77994_a);
            boolean full = false;
            if (itemCount - stack.field_77994_a <= 0 && !this.getFlag(1)) {
                this.setStackInSlot(0, null);
                full = true;
            }
            this.markBarrelDirty(full);
        }
        return stack;
    }

    @Override
    public void setUpgradeData(String upgrade, @Nullable NBTBase v) {
        NBTTagCompound nbt = this.getUpgradeNBT();
        if (v != null) {
            if (nbt == null) {
                nbt = new NBTTagCompound();
                this.setUpgradeNBT(nbt);
            }
            nbt.func_74782_a(upgrade, v);
        } else if (nbt != null) {
            nbt.func_82580_o(upgrade);
            if (nbt.func_82582_d()) {
                this.setUpgradeNBT(null);
            }
        }
    }

    @Override
    public void addUpgradeName(String name) {
        NBTTagList list = this.getUpgradeNames();
        if (list == null) {
            list = new NBTTagList();
        }
        list.func_74742_a((NBTBase)new NBTTagString(name));
        this.setUpgradeNames(list);
    }

    @Override
    public void copyFrom(IBarrel barrel) {
        this.setTier(barrel.getTier());
        this.setFlags(barrel.getFlags());
        this.setItemCount(barrel.getItemCount());
        this.setStackInSlot(0, barrel.getStackInSlot(0));
        this.setModel(barrel.getModel());
        this.setSkin(barrel.getSkin());
        NBTTagCompound upgradeNBT = barrel.getUpgradeNBT();
        this.setUpgradeNBT(upgradeNBT == null ? null : upgradeNBT.func_74737_b());
        NBTTagList upgradeNames = barrel.getUpgradeNames();
        this.setUpgradeNames(upgradeNames == null ? null : upgradeNames.func_74737_b());
    }

    @Override
    public int getFreeSpace() {
        return this.getTier().getMaxItems(this, this.getStackInSlot(0)) - this.getItemCount();
    }
}

