/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftbl.api.config.IConfigContainer;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.lib.block.EnumRotation;
import com.feed_the_beast.ftbl.lib.config.BasicConfigContainer;
import com.feed_the_beast.ftbl.lib.config.ConfigTree;
import com.feed_the_beast.ftbl.lib.util.InvUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.google.gson.JsonObject;
import com.latmod.yabba.FTBLibIntegration;
import com.latmod.yabba.YabbaCommon;
import com.latmod.yabba.YabbaConfig;
import com.latmod.yabba.api.IUpgrade;
import com.latmod.yabba.api.events.YabbaCreateConfigEvent;
import com.latmod.yabba.block.BlockBarrel;
import com.latmod.yabba.net.MessageUpdateBarrelFull;
import com.latmod.yabba.net.MessageUpdateBarrelItemCount;
import com.latmod.yabba.tile.BarrelTileContainer;
import com.latmod.yabba.util.EnumRedstoneCompMode;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileBarrel
extends TileEntity
implements ITickable,
IDeepStorageUnit {
    public static final double BUTTON_SIZE = 0.24;
    private BarrelTileContainer barrel = new BarrelTileContainer(){

        @Override
        public void markBarrelDirty(boolean full) {
            if (full) {
                TileBarrel.this.sendUpdate = 2;
            } else if (TileBarrel.this.sendUpdate == 0) {
                TileBarrel.this.sendUpdate = 1;
            }
        }

        @Override
        public void clearCachedData() {
            TileBarrel.this.cachedItemName = null;
            TileBarrel.this.cachedItemCount = null;
            TileBarrel.this.cachedRotationX = -1.0f;
            TileBarrel.this.cachedRotationY = -1.0f;
        }
    };
    private String cachedItemName;
    private String cachedItemCount;
    private float cachedRotationX;
    private float cachedRotationY;
    private int sendUpdate = 2;
    public boolean requestClientUpdate = true;

    public TileBarrel() {
        this.barrel.clearCachedData();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.barrel.deserializeNBT(nbt.func_74775_l("Barrel"));
        this.barrel.clearCachedData();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("Barrel", (NBTBase)this.barrel.serializeNBT());
        return nbt;
    }

    public void func_73660_a() {
        if (this.sendUpdate > 0) {
            if (this.sendUpdate > 1) {
                this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            }
            if (!this.field_145850_b.field_72995_K) {
                (this.sendUpdate > 1 ? new MessageUpdateBarrelFull(this.field_174879_c, this.barrel) : new MessageUpdateBarrelItemCount(this.field_174879_c, this.barrel.getItemCount())).sendToAllAround(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, 300.0);
            }
            if (this.barrel.getFlag(64)) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            }
            this.sendUpdate = 0;
        }
        if (!this.field_145850_b.field_72995_K && this.barrel.getFlag(128) && this.field_145850_b.func_82737_E() % 8L == (long)(this.field_174879_c.hashCode() & 7)) {
            TileEntity tileUp;
            TileEntity tileDown;
            int maxItems;
            boolean ender = this.barrel.getFlag(256);
            int n = maxItems = ender ? 64 : 1;
            if (this.barrel.getItemCount() > 0 && this.barrel.getUpgradeNBT().func_74767_n("HopperDown") && (tileDown = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.DOWN))) != null && tileDown.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                InvUtils.transferItems((IItemHandler)this.barrel, (IItemHandler)((IItemHandler)tileDown.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)), (int)Math.min(maxItems, this.barrel.getItemCount()), (Predicate)LMUtils.alwaysTruePredicate());
            }
            if (this.barrel.getUpgradeNBT().func_74767_n("HopperUp") && (tileUp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.UP))) != null && tileUp.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                InvUtils.transferItems((IItemHandler)((IItemHandler)tileUp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)), (IItemHandler)this.barrel, (int)Math.min(maxItems, this.barrel.getFreeSpace()), (Predicate)LMUtils.alwaysTruePredicate());
            }
            if (this.barrel.getUpgradeNBT().func_74767_n("HopperCollect")) {
                AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 1, 0), this.field_174879_c.func_177982_a(1, 2, 1));
                if (ender) {
                    aabb = aabb.func_72314_b(5.0, 5.0, 5.0);
                }
                for (EntityItem item : this.field_145850_b.func_175647_a(EntityItem.class, aabb, null)) {
                    ItemStack stack = this.barrel.insertItem(0, item.func_92059_d().func_77946_l(), false);
                    item.func_92058_a(stack);
                    if (stack != null && stack.field_77994_a != 0) continue;
                    item.func_70106_y();
                }
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        this.barrel.clearCachedData();
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_70296_d() {
        this.barrel.markBarrelDirty(true);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == YabbaCommon.BARREL_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == YabbaCommon.BARREL_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.barrel;
        }
        return (T)super.getCapability(capability, facing);
    }

    public String getItemDisplayName() {
        if (this.cachedItemName == null) {
            ItemStack is = this.barrel.getStackInSlot(0);
            this.cachedItemName = is == null ? "" : is.func_82833_r();
        }
        return this.cachedItemName;
    }

    public String getItemDisplayCount(boolean sneaking) {
        if (this.barrel.getFlag(8)) {
            return "INF";
        }
        if (sneaking) {
            return this.barrel.getItemCount() + " / " + this.barrel.getTier().getMaxItems(this.barrel, this.barrel.getStackInSlot(0));
        }
        if (this.cachedItemCount == null) {
            ItemStack is = this.barrel.getStackInSlot(0);
            int max = is == null ? 64 : is.func_77976_d();
            int c = this.barrel.getItemCount();
            if (max == 1 || c <= max) {
                this.cachedItemCount = Integer.toString(c);
            } else {
                this.cachedItemCount = c / max + "x" + max;
                int extra = c % max;
                if (extra != 0) {
                    this.cachedItemCount = this.cachedItemCount + "+" + extra;
                }
            }
        }
        return this.cachedItemCount;
    }

    public float getRotationAngleX() {
        if (this.cachedRotationX == -1.0f) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockBarrel)) {
                return 0.0f;
            }
            this.cachedRotationX = (float)((EnumRotation)state.func_177229_b(BlockBarrel.ROTATION)).ordinal() * 90.0f;
        }
        return this.cachedRotationX;
    }

    public float getRotationAngleY() {
        if (this.cachedRotationY == -1.0f) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockBarrel)) {
                return 0.0f;
            }
            this.cachedRotationY = ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_185119_l() + 180.0f;
        }
        return this.cachedRotationY;
    }

    public void onLeftClick(EntityPlayer playerIn) {
        int size;
        ItemStack stack;
        ItemStack storedItem = this.barrel.getStackInSlot(0);
        if (storedItem != null && this.barrel.getItemCount() == 0 && (this.barrel.getFlags() & 1) == 0) {
            this.barrel.setStackInSlot(0, null);
            this.barrel.markBarrelDirty(true);
            return;
        }
        if (storedItem != null && this.barrel.getItemCount() > 0 && (stack = this.barrel.extractItem(0, size = YabbaConfig.SNEAK_LEFT_CLICK_EXTRACTS_STACK.getBoolean() == playerIn.func_70093_af() ? storedItem.func_77976_d() : 1, false)) != null) {
            if (playerIn.field_71071_by.func_70441_a(stack)) {
                playerIn.field_71071_by.func_70296_d();
                if (playerIn.field_71070_bA != null) {
                    playerIn.field_71070_bA.func_75142_b();
                }
            } else {
                EntityItem ei = new EntityItem(playerIn.field_70170_p, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, stack);
                ei.field_70179_y = 0.0;
                ei.field_70181_x = 0.0;
                ei.field_70159_w = 0.0;
                ei.func_174867_a(0);
                playerIn.field_70170_p.func_72838_d((Entity)ei);
            }
        }
    }

    public void onRightClick(EntityPlayer playerIn, IBlockState state, @Nullable ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing facing, long deltaClickTime) {
        if (deltaClickTime <= 8L) {
            if (this.barrel.getStackInSlot(0) != null) {
                for (int i = 0; i < playerIn.field_71071_by.field_70462_a.length; ++i) {
                    ItemStack is = this.barrel.insertItem(0, playerIn.field_71071_by.field_70462_a[i], false);
                    if (is == playerIn.field_71071_by.field_70462_a[i]) continue;
                    int n = playerIn.field_71071_by.field_70462_a[i].field_77994_a = is == null ? 0 : is.field_77994_a;
                    if (playerIn.field_71071_by.field_70462_a[i].field_77994_a > 0) continue;
                    playerIn.field_71071_by.field_70462_a[i] = null;
                }
            }
            playerIn.field_71071_by.func_70296_d();
            if (playerIn.field_71070_bA != null) {
                playerIn.field_71070_bA.func_75142_b();
            }
            return;
        }
        if (heldItem == null) {
            if (playerIn.func_70093_af()) {
                float x = facing == EnumFacing.UP || facing == EnumFacing.DOWN ? TileBarrel.getX((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D), hitX, hitZ) : TileBarrel.getX(facing, hitX, hitZ);
                if ((double)x < 0.24) {
                    ConfigTree tree = new ConfigTree();
                    MinecraftForge.EVENT_BUS.post((Event)new YabbaCreateConfigEvent(this, this.barrel, (IConfigTree)tree));
                    FTBLibIntegration.API.editServerConfig((EntityPlayerMP)playerIn, null, (IConfigContainer)new BasicConfigContainer((ITextComponent)new TextComponentTranslation(this.func_145838_q().func_149739_a() + ".name", new Object[0]), (IConfigTree)tree){

                        public void saveConfig(ICommandSender sender, @Nullable NBTTagCompound nbt, JsonObject json) {
                            super.saveConfig(sender, nbt, json);
                            TileBarrel.this.barrel.markBarrelDirty(true);
                        }
                    });
                } else if ((double)x > 0.76 && !this.barrel.getFlag(8)) {
                    this.barrel.setFlag(1, !this.barrel.getFlag(1));
                    if (this.barrel.getStackInSlot(0) != null && this.barrel.getItemCount() == 0 && !this.barrel.getFlag(1)) {
                        this.barrel.setStackInSlot(0, null);
                    }
                }
                this.func_70296_d();
                return;
            }
            playerIn.field_71071_by.func_70296_d();
            if (playerIn.field_71070_bA != null) {
                playerIn.field_71070_bA.func_75142_b();
            }
        } else if (heldItem.hasCapability(YabbaCommon.UPGRADE_CAPABILITY, null)) {
            if (((IUpgrade)heldItem.getCapability(YabbaCommon.UPGRADE_CAPABILITY, null)).applyOn(this.barrel, this.field_145850_b, heldItem, false)) {
                if (!heldItem.func_77973_b().hasContainerItem(heldItem)) {
                    --heldItem.field_77994_a;
                }
                this.func_70296_d();
            }
        } else {
            ItemStack is = this.barrel.insertItem(0, heldItem, false);
            heldItem.field_77994_a = is == null ? 0 : is.field_77994_a;
        }
        this.func_70296_d();
    }

    private static float getX(EnumFacing facing, float hitX, float hitZ) {
        switch (facing) {
            case EAST: {
                return 1.0f - hitZ;
            }
            case WEST: {
                return hitZ;
            }
            case NORTH: {
                return 1.0f - hitX;
            }
            case SOUTH: {
                return hitX;
            }
        }
        return 0.5f;
    }

    @Override
    public ItemStack getStoredItemType() {
        return this.barrel.getStackInSlot(0);
    }

    @Override
    public void setStoredItemCount(int amount) {
        if (amount != this.barrel.getItemCount() && !this.barrel.getFlag(8)) {
            int max;
            boolean wasEmpty;
            boolean bl = wasEmpty = this.barrel.getItemCount() == 0;
            if (amount > 0 && this.barrel.getFlag(2) && amount > (max = this.barrel.getTier().getMaxItems(this.barrel, this.barrel.getStackInSlot(0)))) {
                amount = max;
            }
            this.barrel.setItemCount(amount);
            if (amount == 0 && !this.barrel.getFlag(1)) {
                this.barrel.setStackInSlot(0, null);
            }
            this.barrel.markBarrelDirty(wasEmpty != (amount == 0));
        }
    }

    @Override
    public void setStoredItemType(ItemStack type, int amount) {
        if (!this.barrel.getFlag(8) && amount != this.barrel.getItemCount()) {
            boolean wasEmpty = this.barrel.getItemCount() == 0;
            this.barrel.setItemCount(amount);
            if (amount == 0 && !this.barrel.getFlag(1)) {
                type = null;
            }
            this.barrel.setStackInSlot(0, type);
            this.barrel.markBarrelDirty(wasEmpty != (amount == 0));
        }
    }

    @Override
    public int getMaxStoredCount() {
        int i = this.barrel.getTier().getMaxItems(this.barrel, this.barrel.getStackInSlot(0));
        return i + (this.barrel.getFlag(2) ? 256 : 0);
    }

    public boolean canConnectRedstone(EnumFacing facing) {
        return this.barrel.getFlag(64);
    }

    public int redstoneOutput(EnumFacing facing) {
        if (this.barrel.getFlag(64)) {
            int stored = this.barrel.getItemCount();
            int count = this.barrel.getUpgradeNBT().func_74762_e("RedstoneItemCount");
            return EnumRedstoneCompMode.getMode(this.barrel.getUpgradeNBT().func_74771_c("RedstoneMode")).matchesCount(stored, count) ? 15 : 0;
        }
        return 0;
    }
}

