/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.latmod.yabba.YabbaRegistry;
import com.latmod.yabba.api.IBarrelModel;
import com.latmod.yabba.api.IBarrelSkin;
import com.latmod.yabba.api.ITier;
import com.latmod.yabba.models.ModelBarrel;
import com.latmod.yabba.util.Barrel;
import com.latmod.yabba.util.Tier;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class BarrelTileContainer
extends Barrel
implements INBTSerializable<NBTTagCompound> {
    private ITier tier;
    private int flags;
    private ItemStack storedItem;
    private int itemCount;
    private NBTTagCompound upgrades;
    private NBTTagList upgradeNames;
    private IBarrelSkin skin;
    private IBarrelModel model;

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("Tier", this.getTier().func_176610_l());
        nbt.func_74768_a("Flags", this.flags);
        if (this.storedItem != null) {
            this.storedItem.field_77994_a = 1;
            nbt.func_74782_a("Item", (NBTBase)this.storedItem.serializeNBT());
            nbt.func_74768_a("Count", this.getItemCount());
        }
        if (this.upgrades != null && !this.upgrades.func_82582_d()) {
            nbt.func_74782_a("Upgrades", (NBTBase)this.upgrades);
        }
        nbt.func_74778_a("Model", this.getModel().func_176610_l());
        nbt.func_74778_a("Skin", this.getSkin().func_176610_l());
        if (this.upgradeNames != null && !this.upgradeNames.func_82582_d()) {
            nbt.func_74782_a("UpgradeNames", (NBTBase)this.upgradeNames);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        String tierID = nbt.func_74779_i("Tier");
        this.tier = YabbaRegistry.INSTANCE.getTier(tierID);
        this.flags = nbt.func_74762_e("Flags");
        this.storedItem = nbt.func_74764_b("Item") ? ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Item")) : null;
        this.itemCount = this.storedItem == null ? 0 : nbt.func_74762_e("Count");
        this.upgrades = nbt.func_74764_b("Upgrades") ? nbt.func_74775_l("Upgrades") : null;
        this.model = YabbaRegistry.INSTANCE.getModel(nbt.func_74779_i("Model"));
        this.skin = YabbaRegistry.INSTANCE.getSkin(nbt.func_74779_i("Skin"));
        NBTTagList nBTTagList = this.upgradeNames = nbt.func_74764_b("UpgradeNames") ? nbt.func_150295_c("UpgradeNames", 8) : null;
        if (this.getFlag(8)) {
            this.itemCount = this.tier.getMaxItems(this, this.getStackInSlot(0)) / 2;
        }
    }

    @Nullable
    public ItemStack getStackInSlot(int slot) {
        if (this.storedItem != null) {
            this.storedItem.field_77994_a = this.getItemCount();
        }
        return this.storedItem;
    }

    @Override
    public ITier getTier() {
        return this.tier == null ? Tier.WOOD : this.tier;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public NBTTagCompound getUpgradeNBT() {
        if (this.upgrades == null) {
            this.upgrades = new NBTTagCompound();
        }
        return this.upgrades;
    }

    @Override
    public IBarrelSkin getSkin() {
        if (this.skin == null) {
            this.skin = YabbaRegistry.DEFAULT_SKIN;
        }
        return this.skin;
    }

    @Override
    public IBarrelModel getModel() {
        if (this.model == null) {
            this.model = ModelBarrel.INSTANCE;
        }
        return this.model;
    }

    @Override
    @Nullable
    public NBTTagList getUpgradeNames() {
        return this.upgradeNames;
    }

    public void setStackInSlot(int slot, @Nullable ItemStack stack) {
        this.storedItem = stack;
    }

    @Override
    public void setTier(ITier t) {
        this.tier = t;
    }

    @Override
    public void setFlags(int f) {
        this.flags = f;
    }

    @Override
    public void setItemCount(int v) {
        this.itemCount = v;
    }

    @Override
    public void setUpgradeNBT(@Nullable NBTTagCompound nbt) {
        this.upgrades = nbt;
    }

    @Override
    public void setSkin(IBarrelSkin v) {
        this.skin = v;
    }

    @Override
    public void setModel(IBarrelModel m) {
        this.model = m;
    }

    @Override
    public void setUpgradeNames(@Nullable NBTTagList nbt) {
        this.upgradeNames = nbt;
    }
}

