/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.net;

import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.lib.util.NetUtils;
import com.latmod.yabba.YabbaCommon;
import com.latmod.yabba.YabbaRegistry;
import com.latmod.yabba.api.IBarrel;
import com.latmod.yabba.api.IBarrelModel;
import com.latmod.yabba.api.IBarrelModifiable;
import com.latmod.yabba.api.IBarrelSkin;
import com.latmod.yabba.block.BlockBarrel;
import com.latmod.yabba.net.YabbaNetHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageUpdateBarrelFull
extends MessageToClient<MessageUpdateBarrelFull> {
    private String model;
    private String skin;
    private String tier;
    private BlockPos pos;
    private int itemCount;
    private int flags;
    private ItemStack storedItem;
    private NBTTagCompound upgrades;

    public MessageUpdateBarrelFull() {
    }

    public MessageUpdateBarrelFull(BlockPos p, IBarrel barrel) {
        this.pos = p;
        this.storedItem = barrel.getStackInSlot(0);
        this.itemCount = barrel.getItemCount();
        this.flags = barrel.getFlags();
        this.upgrades = barrel.getUpgradeNBT();
        this.model = barrel.getModel().func_176610_l();
        this.skin = barrel.getSkin().func_176610_l();
        this.tier = barrel.getTier().func_176610_l();
    }

    public NetworkWrapper getWrapper() {
        return YabbaNetHandler.NET;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetUtils.readPos((ByteBuf)buf);
        this.storedItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.itemCount = buf.readInt();
        this.flags = buf.readInt();
        this.upgrades = ByteBufUtils.readTag((ByteBuf)buf);
        this.model = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.skin = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.tier = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetUtils.writePos((ByteBuf)buf, (Vec3i)this.pos);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.storedItem);
        buf.writeInt(this.itemCount);
        buf.writeInt(this.flags);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.upgrades);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.model);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.skin);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.tier);
    }

    public void onMessage(MessageUpdateBarrelFull message, EntityPlayer player) {
        TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
        if (tile != null && tile.hasCapability(YabbaCommon.BARREL_CAPABILITY, null)) {
            IBarrelModifiable barrel = (IBarrelModifiable)tile.getCapability(YabbaCommon.BARREL_CAPABILITY, null);
            IBarrelModel model = YabbaRegistry.INSTANCE.getModel(message.model);
            IBarrelSkin skin = YabbaRegistry.INSTANCE.getSkin(message.skin);
            boolean updateVariant = !barrel.getModel().equals(model) || !barrel.getSkin().equals(skin);
            barrel.setFlags(message.flags);
            barrel.setStackInSlot(0, message.storedItem);
            barrel.setItemCount(message.itemCount);
            barrel.setUpgradeNBT(message.upgrades);
            barrel.setModel(model);
            barrel.setSkin(skin);
            barrel.setTier(YabbaRegistry.INSTANCE.getTier(message.tier));
            barrel.clearCachedData();
            if (updateVariant) {
                IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
                state = state.func_177226_a((IProperty)BlockBarrel.MODEL, (Comparable)model);
                state = state.func_177226_a((IProperty)BlockBarrel.SKIN, (Comparable)skin);
                tile.func_145831_w().func_175656_a(tile.func_174877_v(), state);
                tile.func_145831_w().func_184138_a(tile.func_174877_v(), state, state, 8);
            }
        }
    }
}

