/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.models;

import com.feed_the_beast.ftbl.lib.IconSet;
import com.feed_the_beast.ftbl.lib.client.ModelBuilder;
import com.feed_the_beast.ftbl.lib.client.SpriteSet;
import com.google.common.base.Function;
import com.latmod.yabba.api.IBarrel;
import com.latmod.yabba.models.ModelBase;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelSolid
extends ModelBase {
    private static final IconSet TEXTURE_WINDOW = new IconSet("north=yabba:blocks/barrel_solid_window");

    public ModelSolid(String id) {
        super(id);
    }

    @Override
    public Collection<ResourceLocation> getExtraTextures() {
        return TEXTURE_WINDOW.getTextures();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> buildModel(IBarrel barrel, ModelRotation rotation, Function<ResourceLocation, TextureAtlasSprite> textureAtlas) {
        ModelBuilder model = new ModelBuilder(rotation);
        SpriteSet spriteSet = new SpriteSet(barrel.getSkin().getTextures(), textureAtlas);
        model.addCube(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, spriteSet.exclude(new EnumFacing[]{EnumFacing.NORTH}));
        model.addQuad(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 0.0f, EnumFacing.NORTH, (TextureAtlasSprite)textureAtlas.apply((Object)TEXTURE_WINDOW.getTexture(EnumFacing.NORTH)));
        TextureAtlasSprite frontSprite = spriteSet.get(EnumFacing.NORTH);
        model.addInvertedCube(4.0f, 4.0f, 0.0f, 12.0f, 12.0f, 1.0f, spriteSet);
        model.addQuad(0.0f, 0.0f, 0.0f, 16.0f, 4.0f, 0.0f, EnumFacing.NORTH, frontSprite);
        model.addQuad(0.0f, 12.0f, 0.0f, 16.0f, 16.0f, 0.0f, EnumFacing.NORTH, frontSprite);
        model.addQuad(0.0f, 4.0f, 0.0f, 4.0f, 12.0f, 0.0f, EnumFacing.NORTH, frontSprite);
        model.addQuad(12.0f, 4.0f, 0.0f, 16.0f, 12.0f, 0.0f, EnumFacing.NORTH, frontSprite);
        return model.getQuads();
    }
}

