/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.models;

import com.feed_the_beast.ftbl.lib.client.ModelBuilder;
import com.feed_the_beast.ftbl.lib.client.SpriteSet;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.google.common.base.Function;
import com.latmod.yabba.api.IBarrel;
import com.latmod.yabba.block.BlockBarrel;
import com.latmod.yabba.models.ModelBase;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModelPanel
extends ModelBase {
    private final float height;
    private final AxisAlignedBB[] boxes;

    public ModelPanel(String id, float h) {
        super(id);
        this.height = h;
        this.boxes = MathUtils.getRotatedBoxes((AxisAlignedBB)new AxisAlignedBB(0.0, 1.0 - (double)this.height, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public Collection<ResourceLocation> getExtraTextures() {
        return Collections.emptyList();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> buildModel(IBarrel barrel, ModelRotation rotation, Function<ResourceLocation, TextureAtlasSprite> textureAtlas) {
        ModelBuilder model = new ModelBuilder(rotation);
        SpriteSet spriteSet = new SpriteSet(barrel.getSkin().getTextures(), textureAtlas);
        model.addCube(0.0f, 0.0f, 16.0f - this.height * 16.0f, 16.0f, 16.0f, 16.0f, spriteSet);
        return model.getQuads();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> buildItemModel(IBarrel barrel, Function<ResourceLocation, TextureAtlasSprite> textureAtlas) {
        ModelBuilder model = new ModelBuilder(ModelRotation.X0_Y0);
        SpriteSet spriteSet = new SpriteSet(barrel.getSkin().getTextures(), textureAtlas);
        model.addCube(0.0f, 0.0f, 8.0f - this.height * 8.0f, 16.0f, 16.0f, 8.0f + this.height * 8.0f, spriteSet);
        return model.getQuads();
    }

    @Override
    public float getTextDistance() {
        return 1.0f - this.height - 0.005f;
    }

    @Override
    public float getItemDistance() {
        return 1.0f - this.height - 0.01f;
    }

    @Override
    public AxisAlignedBB getAABB(IBlockState state, IBlockAccess world, BlockPos pos, IBarrel barrel) {
        return this.boxes[BlockBarrel.normalizeFacing(state).func_176745_a()];
    }
}

