/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client.gui;

import com.latmod.yabba.YabbaRegistry;
import com.latmod.yabba.api.IBarrelSkin;
import com.latmod.yabba.client.gui.GuiYabba;
import com.latmod.yabba.net.MessageSelectSkin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiSelectSkin
extends GuiYabba {
    public static final GuiSelectSkin INSTANCE = new GuiSelectSkin();
    private static final Button SEARCH_BAR = new Button(3, 3, 187, 12);
    private static final Button SCROLL_BAR = new Button(174, 20, 16, 111);
    private static final Button SKINS_PANEL = new Button(1, 18, 171, 115);
    private final List<Skin> ALL_SKINS = new ArrayList<Skin>();
    private List<Skin> visibleSkins = new ArrayList<Skin>();
    private String searchBar = "";
    private boolean searchSelected = false;
    private boolean updateVisibleSkins = true;
    private float scroll = 0.0f;
    private float skinsHeight;
    private boolean scrollGrabbed = false;

    private GuiSelectSkin() {
        super(new ResourceLocation("yabba", "textures/gui/skin.png"), 193, 155);
    }

    public void initSkins() {
        this.ALL_SKINS.clear();
        for (int i = 0; i < YabbaRegistry.ALL_SKINS.size(); ++i) {
            this.ALL_SKINS.add(new Skin(0, YabbaRegistry.ALL_SKINS.get(i)));
        }
    }

    private void updateVisibleSkins() {
        ArrayList<Skin> matchingSkins;
        this.visibleSkins.clear();
        this.scroll = 0.0f;
        ArrayList<Skin> arrayList = matchingSkins = this.searchBar.isEmpty() ? this.ALL_SKINS : new ArrayList<Skin>();
        if (!this.searchBar.isEmpty()) {
            String searchBar1 = this.searchBar.toLowerCase().replace(" ", "");
            for (Skin skin : this.ALL_SKINS) {
                if (!skin.mouseOverText.toLowerCase().replace(" ", "").contains(searchBar1)) continue;
                matchingSkins.add(skin);
            }
        }
        this.skinsHeight = (float)MathHelper.func_76123_f((float)((float)matchingSkins.size() / 9.0f)) * 19.0f - (float)GuiSelectSkin.SKINS_PANEL.height + 1.0f;
        if (!matchingSkins.isEmpty()) {
            for (int i = 0; i < matchingSkins.size(); ++i) {
                Skin skin = (Skin)matchingSkins.get(i);
                skin.index = i;
                skin.updatePos();
                this.visibleSkins.add(skin);
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        if (this.updateVisibleSkins) {
            this.updateVisibleSkins();
            this.updateVisibleSkins = false;
        }
        if (this.skinsHeight > (float)GuiSelectSkin.SKINS_PANEL.height) {
            float scroll0 = this.scroll;
            int mouseWheel = Mouse.getDWheel();
            if (mouseWheel != 0) {
                this.scroll += 19.0f / (mouseWheel > 0 ? -this.skinsHeight : this.skinsHeight);
            }
            if (this.scrollGrabbed) {
                this.scroll = ((float)(mouseY - this.guiY - GuiSelectSkin.SCROLL_BAR.posY) - 6.0f) / ((float)GuiSelectSkin.SCROLL_BAR.height - 12.0f);
            }
            if (this.scroll < 0.0f) {
                this.scroll = 0.0f;
            } else if (this.scroll > 1.0f) {
                this.scroll = 1.0f;
            }
            if (scroll0 != this.scroll) {
                for (Skin skin : this.visibleSkins) {
                    skin.updatePos();
                }
            }
        }
        super.func_73863_a(mouseX, mouseY, ticks);
        int rmouseX = mouseX - this.guiX;
        int rmouseY = mouseY - this.guiY;
        boolean mouseInSkinsPanel = SKINS_PANEL.isMouseOver(rmouseX, rmouseY);
        this.func_73729_b(this.guiX + GuiSelectSkin.SCROLL_BAR.posX, this.guiY + GuiSelectSkin.SCROLL_BAR.posY + (int)(this.scroll * ((float)GuiSelectSkin.SCROLL_BAR.height - 12.0f)), 213, 0, GuiSelectSkin.SCROLL_BAR.width, 12);
        ScaledResolution screen = new ScaledResolution(this.field_146297_k);
        int sf = screen.func_78325_e();
        int scissorX = this.guiX + GuiSelectSkin.SKINS_PANEL.posX;
        int scissorY = this.guiY + GuiSelectSkin.SKINS_PANEL.posY;
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(scissorX * sf), (int)(screen.func_78328_b() * sf - (scissorY * sf + GuiSelectSkin.SKINS_PANEL.height * sf)), (int)(GuiSelectSkin.SKINS_PANEL.width * sf), (int)(GuiSelectSkin.SKINS_PANEL.height * sf));
        for (Skin skin : this.visibleSkins) {
            if (!skin.isVisible()) continue;
            this.func_73729_b(this.guiX + skin.posX, this.guiY + skin.posY, 194, mouseInSkinsPanel && skin.isMouseOver(rmouseX, rmouseY) ? 19 : 0, skin.width, skin.height);
        }
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        for (Skin skin : this.visibleSkins) {
            if (!skin.isVisible()) continue;
            TextureAtlasSprite sprite = this.field_146297_k.func_147117_R().func_110572_b(skin.spriteName);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            double x = (double)(this.guiX + skin.posX) + 1.0;
            double y = (double)(this.guiY + skin.posY) + 1.0;
            buffer.func_181662_b(x, y + 16.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(x + 16.0, y + 16.0, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
            buffer.func_181662_b(x + 16.0, y, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
            buffer.func_181662_b(x, y, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
        }
        GL11.glDisable((int)3089);
        String searchBarText = this.searchBar;
        if (this.searchSelected && System.currentTimeMillis() % 800L >= 400L) {
            searchBarText = searchBarText + '_';
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(searchBarText, this.guiX + 6, this.guiY + 5, -1);
        if (mouseInSkinsPanel) {
            for (Skin skin : this.visibleSkins) {
                if (skin.mouseOverText.isEmpty() || !skin.isMouseOver(rmouseX, rmouseY)) continue;
                this.func_146283_a(Collections.singletonList(skin.mouseOverText), mouseX, mouseY);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.searchSelected = false;
        int rmouseX = mouseX - this.guiX;
        int rmouseY = mouseY - this.guiY;
        if (SEARCH_BAR.isMouseOver(rmouseX, rmouseY)) {
            this.searchSelected = true;
            if (mouseButton != 0) {
                this.searchBar = "";
                this.updateVisibleSkins = true;
            }
        } else if (SCROLL_BAR.isMouseOver(rmouseX, rmouseY)) {
            this.scrollGrabbed = true;
        } else if (SKINS_PANEL.isMouseOver(rmouseX, rmouseY)) {
            for (Skin skin : this.visibleSkins) {
                if (!skin.isMouseOver(rmouseX, rmouseY)) continue;
                new MessageSelectSkin(skin.skin.func_176610_l()).sendToServer();
                GuiSelectSkin.INSTANCE.field_146297_k.field_71439_g.func_71053_j();
                return;
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.scrollGrabbed = false;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        block7: {
            block6: {
                if (!this.searchSelected) break block6;
                switch (keyCode) {
                    case 1: 
                    case 15: 
                    case 28: {
                        this.searchSelected = false;
                        break;
                    }
                    case 14: {
                        if (!this.searchBar.isEmpty()) {
                            this.searchBar = GuiSelectSkin.func_146272_n() ? "" : this.searchBar.substring(0, this.searchBar.length() - 1);
                            this.updateVisibleSkins = true;
                            break;
                        }
                        break block7;
                    }
                    default: {
                        if (typedChar >= 'a' && typedChar <= 'z' || typedChar >= 'A' && typedChar <= 'Z' || typedChar >= '0' && typedChar <= '1' || " .,/-_".indexOf(typedChar) != -1) {
                            this.searchBar = this.searchBar + typedChar;
                            this.updateVisibleSkins = true;
                            break;
                        }
                        break block7;
                    }
                }
                break block7;
            }
            super.func_73869_a(typedChar, keyCode);
        }
    }

    private class Skin
    extends Button {
        private int index;
        private final IBarrelSkin skin;
        private final String spriteName;
        private String mouseOverText;

        private Skin(int i, IBarrelSkin s) {
            super(0, 0, 18, 18);
            this.mouseOverText = "";
            this.index = i;
            this.skin = s;
            this.mouseOverText = s.getDisplayName();
            this.spriteName = this.skin.getTextures().getTexture(EnumFacing.NORTH).toString();
        }

        void updatePos() {
            this.posX = 2 + this.index % 9 * 19;
            this.posY = 19 + this.index / 9 * 19 - (int)(GuiSelectSkin.this.scroll * GuiSelectSkin.this.skinsHeight);
        }

        boolean isVisible() {
            return this.posY + 19 >= SKINS_PANEL.posY && this.posY - 19 < SKINS_PANEL.posY + SKINS_PANEL.height;
        }
    }

    private static class Button {
        int posX;
        int posY;
        int width;
        int height;

        private Button(int x, int y, int w, int h) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
        }

        boolean isMouseOver(int rmouseX, int rmouseY) {
            return rmouseX >= this.posX && rmouseY >= this.posY && rmouseX < this.posX + this.width && rmouseY < this.posY + this.height;
        }
    }
}

