/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client;

import com.latmod.yabba.YabbaCommon;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.YabbaRegistry;
import com.latmod.yabba.api.IBarrelModel;
import com.latmod.yabba.api.IBarrelSkin;
import com.latmod.yabba.client.BarrelItemMeshDefinition;
import com.latmod.yabba.client.RenderBarrel;
import com.latmod.yabba.client.YabbaModels;
import com.latmod.yabba.client.gui.GuiSelectModel;
import com.latmod.yabba.client.gui.GuiSelectSkin;
import com.latmod.yabba.tile.TileBarrel;
import com.latmod.yabba.util.EnumUpgrade;
import com.latmod.yabba.util.Tier;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class YabbaClient
extends YabbaCommon {
    public static ItemStack[][] STACKS_FOR_GUI;

    @Override
    public void preInit() {
        super.preInit();
        ModelLoader.setCustomStateMapper((Block)YabbaItems.BARREL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockHorizontal.field_185512_D}).func_178441_a());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new YabbaModels());
        Item barrelItem = Item.func_150898_a((Block)YabbaItems.BARREL);
        ArrayList<ModelResourceLocation> variants = new ArrayList<ModelResourceLocation>();
        for (IBarrelModel model : YabbaRegistry.ALL_MODELS) {
            for (IBarrelSkin skin : YabbaRegistry.ALL_SKINS) {
                variants.add(new ModelResourceLocation(YabbaItems.BARREL.getRegistryName(), "model=" + model.func_176610_l() + ",skin=" + skin.func_176610_l()));
            }
        }
        ModelLoader.registerItemVariants((Item)barrelItem, (ResourceLocation[])variants.toArray(new ResourceLocation[variants.size()]));
        ModelLoader.setCustomMeshDefinition((Item)barrelItem, (ItemMeshDefinition)new BarrelItemMeshDefinition(YabbaItems.BARREL.getRegistryName()));
        this.registerModel(Item.func_150898_a((Block)YabbaItems.ANTIBARREL), 0, "antibarrel", "inventory");
        for (EnumUpgrade type : EnumUpgrade.VALUES) {
            this.registerModel((Item)YabbaItems.UPGRADE, type.metadata, "upgrade/" + type.func_176610_l(), "inventory");
        }
        this.registerModel((Item)YabbaItems.PAINTER, 0, "painter", "inventory");
        this.registerModel((Item)YabbaItems.HAMMER, 0, "hammer", "inventory");
        ClientRegistry.bindTileEntitySpecialRenderer(TileBarrel.class, (TileEntitySpecialRenderer)new RenderBarrel());
        STACKS_FOR_GUI = new ItemStack[YabbaRegistry.ALL_MODELS.size()][YabbaRegistry.ALL_SKINS.size()];
        for (int m = 0; m < YabbaRegistry.ALL_MODELS.size(); ++m) {
            for (int s = 0; s < YabbaRegistry.ALL_SKINS.size(); ++s) {
                YabbaClient.STACKS_FOR_GUI[m][s] = YabbaItems.BARREL.createStack(YabbaRegistry.ALL_MODELS.get(m), YabbaRegistry.ALL_SKINS.get(s), Tier.WOOD);
            }
        }
        GuiSelectSkin.INSTANCE.initSkins();
    }

    private void registerModel(@Nullable Item item, int meta, String id, String v) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation("yabba:" + id + '#' + v));
    }

    @Override
    public void openModelGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSelectModel.INSTANCE);
    }

    @Override
    public void openSkinGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSelectSkin.INSTANCE);
    }
}

