/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client;

import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.common.base.Function;
import com.latmod.yabba.YabbaRegistry;
import com.latmod.yabba.api.IBarrel;
import com.latmod.yabba.api.IBarrelModel;
import com.latmod.yabba.api.IBarrelSkin;
import com.latmod.yabba.api.ITier;
import com.latmod.yabba.client.BarrelVariantBakedModel;
import com.latmod.yabba.util.Tier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class BarrelModel
implements IModel {
    public final IBarrel barrel;
    public Collection<ResourceLocation> textures;

    public BarrelModel(String v) {
        Map map = StringUtils.parse((Map)StringUtils.TEMP_MAP, (String)v);
        IBarrelModel model = YabbaRegistry.INSTANCE.getModel((String)map.get("model"));
        IBarrelSkin skin = YabbaRegistry.INSTANCE.getSkin((String)map.get("skin"));
        this.barrel = new BarrelForModel(model, skin);
        Collection tex = skin.getTextures().getTextures();
        tex.addAll(model.getExtraTextures());
        this.textures = Collections.unmodifiableCollection(new ArrayList(tex));
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ArrayList<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(ModelRotation.values().length);
        for (ModelRotation rotation : ModelRotation.values()) {
            quads.add(this.barrel.getModel().buildModel(this.barrel, rotation, bakedTextureGetter));
        }
        List noStateQuads = this.barrel.getModel().buildItemModel(this.barrel, bakedTextureGetter);
        if (noStateQuads == null) {
            noStateQuads = (List)quads.get(0);
        }
        return new BarrelVariantBakedModel((TextureAtlasSprite)bakedTextureGetter.apply((Object)this.barrel.getSkin().getTextures().getTexture(EnumFacing.NORTH)), quads, noStateQuads);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    private static class BarrelForModel
    implements IBarrel {
        private final IBarrelModel model;
        private final IBarrelSkin skin;

        private BarrelForModel(IBarrelModel m, IBarrelSkin s) {
            this.model = m;
            this.skin = s;
        }

        @Override
        public ITier getTier() {
            return Tier.WOOD;
        }

        @Override
        public int getFlags() {
            return 0;
        }

        @Override
        public boolean getFlag(int flag) {
            return false;
        }

        @Override
        public int getItemCount() {
            return 0;
        }

        @Override
        public IBarrelModel getModel() {
            return this.model;
        }

        @Override
        public IBarrelSkin getSkin() {
            return this.skin;
        }

        @Override
        public NBTTagCompound getUpgradeNBT() {
            return new NBTTagCompound();
        }

        @Override
        @Nullable
        public NBTTagList getUpgradeNames() {
            return null;
        }

        @Override
        public int getFreeSpace() {
            return 0;
        }

        public int getSlots() {
            return 0;
        }

        public ItemStack getStackInSlot(int slot) {
            return null;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }
    }
}

