/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.block;

import com.feed_the_beast.ftbl.lib.block.EnumRotation;
import com.latmod.yabba.YabbaCommon;
import com.latmod.yabba.YabbaRegistry;
import com.latmod.yabba.api.IBarrel;
import com.latmod.yabba.api.IBarrelModel;
import com.latmod.yabba.api.IBarrelModifiable;
import com.latmod.yabba.api.IBarrelSkin;
import com.latmod.yabba.api.ITier;
import com.latmod.yabba.block.BlockBarrelBase;
import com.latmod.yabba.item.ItemBlockBarrel;
import com.latmod.yabba.models.ModelBarrel;
import com.latmod.yabba.tile.TileBarrel;
import com.latmod.yabba.util.PropertyBarrelModel;
import com.latmod.yabba.util.PropertyBarrelSkin;
import com.latmod.yabba.util.Tier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBarrel
extends BlockBarrelBase {
    public static final Map<UUID, Long> LAST_CLICK_MAP = new HashMap<UUID, Long>();
    public static final PropertyEnum<EnumRotation> ROTATION = PropertyEnum.func_177709_a((String)"rotation", EnumRotation.class);
    public static final PropertyBarrelModel MODEL = PropertyBarrelModel.create("model");
    public static final PropertyBarrelSkin SKIN = PropertyBarrelSkin.create("skin");

    public BlockBarrel() {
        super("barrel", Material.field_151575_d, MapColor.field_151663_o);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ROTATION, (Comparable)EnumRotation.NORMAL).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)MODEL, (Comparable)ModelBarrel.INSTANCE).func_177226_a((IProperty)SKIN, (Comparable)YabbaRegistry.DEFAULT_SKIN));
        this.func_149711_c(2.0f);
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockBarrel((Block)this);
    }

    public static EnumFacing normalizeFacing(IBlockState state) {
        EnumRotation rotation = (EnumRotation)state.func_177229_b(ROTATION);
        if (rotation == EnumRotation.FACING_DOWN) {
            return EnumFacing.DOWN;
        }
        if (rotation == EnumRotation.FACING_UP) {
            return EnumFacing.UP;
        }
        return (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }

    @Override
    public void dropItem(ItemStack itemStack, @Nullable TileEntity tile) {
        if (tile instanceof TileBarrel) {
            IBarrel barrel = (IBarrel)tile.getCapability(YabbaCommon.BARREL_CAPABILITY, null);
            ((IBarrelModifiable)itemStack.getCapability(YabbaCommon.BARREL_CAPABILITY, null)).copyFrom(barrel);
        }
    }

    @Override
    public void placeFromItem(ItemStack stack, @Nullable TileEntity tile) {
        if (tile instanceof TileBarrel && stack.hasCapability(YabbaCommon.BARREL_CAPABILITY, null)) {
            IBarrelModifiable barrel = (IBarrelModifiable)tile.getCapability(YabbaCommon.BARREL_CAPABILITY, null);
            barrel.copyFrom((IBarrel)stack.getCapability(YabbaCommon.BARREL_CAPABILITY, null));
            tile.func_70296_d();
        }
    }

    public ItemStack createStack(IBarrelModel model, IBarrelSkin skin, ITier tier) {
        ItemStack stack = new ItemStack((Block)this);
        IBarrelModifiable barrel = (IBarrelModifiable)stack.getCapability(YabbaCommon.BARREL_CAPABILITY, null);
        barrel.setTier(tier);
        barrel.setFlags(0);
        barrel.setModel(model);
        barrel.setSkin(skin);
        barrel.setItemCount(0);
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.hasCapability(YabbaCommon.BARREL_CAPABILITY, null)) {
            IBarrel barrel = (IBarrel)te.getCapability(YabbaCommon.BARREL_CAPABILITY, null);
            ItemStack stack = this.createStack(barrel.getModel(), barrel.getSkin(), barrel.getTier());
            ((IBarrelModifiable)stack.getCapability(YabbaCommon.BARREL_CAPABILITY, null)).copyFrom(barrel);
            return stack;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(this.createStack(ModelBarrel.INSTANCE, YabbaRegistry.DEFAULT_SKIN, Tier.WOOD));
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileBarrel();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockHorizontal.field_185512_D, ROTATION, MODEL, SKIN});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a(ROTATION, (Comparable)EnumRotation.VALUES[meta >> 2 & 3]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumRotation)state.func_177229_b(ROTATION)).ordinal() << 2 | ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b();
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileBarrel) {
            IBarrel barrel = (IBarrel)tile.getCapability(YabbaCommon.BARREL_CAPABILITY, null);
            return state.func_177226_a((IProperty)SKIN, (Comparable)barrel.getSkin()).func_177226_a((IProperty)MODEL, (Comparable)barrel.getModel());
        }
        return state;
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)));
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(YabbaCommon.BARREL_CAPABILITY, null) && ((IBarrel)tile.getCapability(YabbaCommon.BARREL_CAPABILITY, null)).getFlag(32)) {
            return Float.MAX_VALUE;
        }
        return 8.0f;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        IBlockState parent = ((IBarrelSkin)state.func_177229_b((IProperty)SKIN)).getState();
        return parent.func_177230_c().getSoundType(parent, world, pos, entity);
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack stack) {
        return this.func_176223_P().func_177226_a(ROTATION, (Comparable)EnumRotation.getRotationFromEntity((BlockPos)pos, (EntityLivingBase)placer)).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K || playerIn.field_71075_bZ.field_75098_d) {
            return;
        }
        Long l = LAST_CLICK_MAP.get(playerIn.func_146103_bH().getId());
        long time = worldIn.func_82737_E();
        if (l != null && time - l < 3L) {
            return;
        }
        LAST_CLICK_MAP.put(playerIn.func_146103_bH().getId(), time);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileBarrel) {
            ((TileBarrel)tileEntity).onLeftClick(playerIn);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (side != BlockBarrel.normalizeFacing(state) && (heldItem == null || heldItem.func_77973_b() instanceof ItemBlockBarrel)) {
            return false;
        }
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileBarrel) {
            Long l = LAST_CLICK_MAP.get(playerIn.func_146103_bH().getId());
            long time = worldIn.func_82737_E();
            ((TileBarrel)tile).onRightClick(playerIn, state, heldItem, hitX, hitY, hitZ, side, l == null ? Long.MAX_VALUE : time - l);
            if (heldItem == null || !heldItem.hasCapability(YabbaCommon.UPGRADE_CAPABILITY, null)) {
                LAST_CLICK_MAP.put(playerIn.func_146103_bH().getId(), time);
            }
        }
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileBarrel && ((TileBarrel)tile).canConnectRedstone(side);
    }

    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        return tile instanceof TileBarrel ? ((TileBarrel)tile).redstoneOutput(side) : 0;
    }

    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        return tile instanceof TileBarrel ? ((TileBarrel)tile).redstoneOutput(side) : 0;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(YabbaCommon.BARREL_CAPABILITY, null)) {
            IBarrel barrel = (IBarrel)tile.getCapability(YabbaCommon.BARREL_CAPABILITY, null);
            return barrel.getModel().getAABB(state, world, pos, barrel);
        }
        return field_185505_j;
    }
}

